package zio.aws.managedblockchainquery.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.managedblockchainquery.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListTokenBalancesResponse(
    tokenBalances: Iterable[zio.aws.managedblockchainquery.model.TokenBalance],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchainquery.model.ListTokenBalancesResponse = {
    import ListTokenBalancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchainquery.model.ListTokenBalancesResponse
      .builder()
      .tokenBalances(tokenBalances.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchainquery.model.ListTokenBalancesResponse.ReadOnly =
    zio.aws.managedblockchainquery.model.ListTokenBalancesResponse
      .wrap(buildAwsValue())
}
object ListTokenBalancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchainquery.model.ListTokenBalancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.managedblockchainquery.model.ListTokenBalancesResponse =
      zio.aws.managedblockchainquery.model.ListTokenBalancesResponse(
        tokenBalances.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def tokenBalances
        : List[zio.aws.managedblockchainquery.model.TokenBalance.ReadOnly]
    def nextToken: Optional[NextToken]
    def getTokenBalances: ZIO[Any, Nothing, List[
      zio.aws.managedblockchainquery.model.TokenBalance.ReadOnly
    ]] = ZIO.succeed(tokenBalances)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.ListTokenBalancesResponse
  ) extends zio.aws.managedblockchainquery.model.ListTokenBalancesResponse.ReadOnly {
    override val tokenBalances
        : List[zio.aws.managedblockchainquery.model.TokenBalance.ReadOnly] =
      impl
        .tokenBalances()
        .asScala
        .map { item =>
          zio.aws.managedblockchainquery.model.TokenBalance.wrap(item)
        }
        .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.managedblockchainquery.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.ListTokenBalancesResponse
  ): zio.aws.managedblockchainquery.model.ListTokenBalancesResponse.ReadOnly =
    new Wrapper(impl)
}
