package zio.aws.managedblockchainquery.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.managedblockchainquery.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListAssetContractsResponse(
    contracts: Iterable[zio.aws.managedblockchainquery.model.AssetContract],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchainquery.model.ListAssetContractsResponse = {
    import ListAssetContractsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchainquery.model.ListAssetContractsResponse
      .builder()
      .contracts(contracts.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchainquery.model.ListAssetContractsResponse.ReadOnly =
    zio.aws.managedblockchainquery.model.ListAssetContractsResponse
      .wrap(buildAwsValue())
}
object ListAssetContractsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchainquery.model.ListAssetContractsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.managedblockchainquery.model.ListAssetContractsResponse =
      zio.aws.managedblockchainquery.model.ListAssetContractsResponse(
        contracts.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def contracts
        : List[zio.aws.managedblockchainquery.model.AssetContract.ReadOnly]
    def nextToken: Optional[NextToken]
    def getContracts: ZIO[Any, Nothing, List[
      zio.aws.managedblockchainquery.model.AssetContract.ReadOnly
    ]] = ZIO.succeed(contracts)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.ListAssetContractsResponse
  ) extends zio.aws.managedblockchainquery.model.ListAssetContractsResponse.ReadOnly {
    override val contracts
        : List[zio.aws.managedblockchainquery.model.AssetContract.ReadOnly] =
      impl
        .contracts()
        .asScala
        .map { item =>
          zio.aws.managedblockchainquery.model.AssetContract.wrap(item)
        }
        .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.managedblockchainquery.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.ListAssetContractsResponse
  ): zio.aws.managedblockchainquery.model.ListAssetContractsResponse.ReadOnly =
    new Wrapper(impl)
}
