package zio.aws.managedblockchainquery.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.managedblockchainquery.model.primitives.QueryTransactionHash
import scala.jdk.CollectionConverters.*
final case class GetTransactionRequest(
    transactionHash: QueryTransactionHash,
    network: zio.aws.managedblockchainquery.model.QueryNetwork
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchainquery.model.GetTransactionRequest = {
    import GetTransactionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchainquery.model.GetTransactionRequest
      .builder()
      .transactionHash(
        QueryTransactionHash.unwrap(transactionHash): java.lang.String
      )
      .network(network.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchainquery.model.GetTransactionRequest.ReadOnly =
    zio.aws.managedblockchainquery.model.GetTransactionRequest
      .wrap(buildAwsValue())
}
object GetTransactionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchainquery.model.GetTransactionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchainquery.model.GetTransactionRequest =
      zio.aws.managedblockchainquery.model
        .GetTransactionRequest(transactionHash, network)
    def transactionHash: QueryTransactionHash
    def network: zio.aws.managedblockchainquery.model.QueryNetwork
    def getTransactionHash: ZIO[Any, Nothing, QueryTransactionHash] =
      ZIO.succeed(transactionHash)
    def getNetwork
        : ZIO[Any, Nothing, zio.aws.managedblockchainquery.model.QueryNetwork] =
      ZIO.succeed(network)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.GetTransactionRequest
  ) extends zio.aws.managedblockchainquery.model.GetTransactionRequest.ReadOnly {
    override val transactionHash: QueryTransactionHash =
      zio.aws.managedblockchainquery.model.primitives
        .QueryTransactionHash(impl.transactionHash())
    override val network: zio.aws.managedblockchainquery.model.QueryNetwork =
      zio.aws.managedblockchainquery.model.QueryNetwork.wrap(impl.network())
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.GetTransactionRequest
  ): zio.aws.managedblockchainquery.model.GetTransactionRequest.ReadOnly =
    new Wrapper(impl)
}
