package zio.aws.managedblockchainquery.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.managedblockchainquery.model.primitives.ChainAddress
import scala.jdk.CollectionConverters.*
final case class ContractFilter(
    network: zio.aws.managedblockchainquery.model.QueryNetwork,
    tokenStandard: zio.aws.managedblockchainquery.model.QueryTokenStandard,
    deployerAddress: ChainAddress
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchainquery.model.ContractFilter = {
    import ContractFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchainquery.model.ContractFilter
      .builder()
      .network(network.unwrap)
      .tokenStandard(tokenStandard.unwrap)
      .deployerAddress(ChainAddress.unwrap(deployerAddress): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchainquery.model.ContractFilter.ReadOnly =
    zio.aws.managedblockchainquery.model.ContractFilter.wrap(buildAwsValue())
}
object ContractFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchainquery.model.ContractFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchainquery.model.ContractFilter =
      zio.aws.managedblockchainquery.model
        .ContractFilter(network, tokenStandard, deployerAddress)
    def network: zio.aws.managedblockchainquery.model.QueryNetwork
    def tokenStandard: zio.aws.managedblockchainquery.model.QueryTokenStandard
    def deployerAddress: ChainAddress
    def getNetwork
        : ZIO[Any, Nothing, zio.aws.managedblockchainquery.model.QueryNetwork] =
      ZIO.succeed(network)
    def getTokenStandard: ZIO[
      Any,
      Nothing,
      zio.aws.managedblockchainquery.model.QueryTokenStandard
    ] = ZIO.succeed(tokenStandard)
    def getDeployerAddress: ZIO[Any, Nothing, ChainAddress] =
      ZIO.succeed(deployerAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.ContractFilter
  ) extends zio.aws.managedblockchainquery.model.ContractFilter.ReadOnly {
    override val network: zio.aws.managedblockchainquery.model.QueryNetwork =
      zio.aws.managedblockchainquery.model.QueryNetwork.wrap(impl.network())
    override val tokenStandard
        : zio.aws.managedblockchainquery.model.QueryTokenStandard =
      zio.aws.managedblockchainquery.model.QueryTokenStandard
        .wrap(impl.tokenStandard())
    override val deployerAddress: ChainAddress =
      zio.aws.managedblockchainquery.model.primitives
        .ChainAddress(impl.deployerAddress())
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.ContractFilter
  ): zio.aws.managedblockchainquery.model.ContractFilter.ReadOnly = new Wrapper(
    impl
  )
}
