package zio.aws.managedblockchainquery.model
import scala.jdk.CollectionConverters.*
sealed trait QueryTransactionEventType {
  def unwrap: software.amazon.awssdk.services.managedblockchainquery.model.QueryTransactionEventType
}
object QueryTransactionEventType {
  def wrap(
      value: software.amazon.awssdk.services.managedblockchainquery.model.QueryTransactionEventType
  ): zio.aws.managedblockchainquery.model.QueryTransactionEventType =
    value match {
      case software.amazon.awssdk.services.managedblockchainquery.model.QueryTransactionEventType.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.managedblockchainquery.model.QueryTransactionEventType.ERC20_TRANSFER =>
        val r = ERC20_TRANSFER
        r
      case software.amazon.awssdk.services.managedblockchainquery.model.QueryTransactionEventType.ERC20_MINT =>
        val r = ERC20_MINT
        r
      case software.amazon.awssdk.services.managedblockchainquery.model.QueryTransactionEventType.ERC20_BURN =>
        val r = ERC20_BURN
        r
      case software.amazon.awssdk.services.managedblockchainquery.model.QueryTransactionEventType.ERC20_DEPOSIT =>
        val r = ERC20_DEPOSIT
        r
      case software.amazon.awssdk.services.managedblockchainquery.model.QueryTransactionEventType.ERC20_WITHDRAWAL =>
        val r = ERC20_WITHDRAWAL
        r
      case software.amazon.awssdk.services.managedblockchainquery.model.QueryTransactionEventType.ERC721_TRANSFER =>
        val r = ERC721_TRANSFER
        r
      case software.amazon.awssdk.services.managedblockchainquery.model.QueryTransactionEventType.ERC1155_TRANSFER =>
        val r = ERC1155_TRANSFER
        r
      case software.amazon.awssdk.services.managedblockchainquery.model.QueryTransactionEventType.BITCOIN_VIN =>
        val r = BITCOIN_VIN
        r
      case software.amazon.awssdk.services.managedblockchainquery.model.QueryTransactionEventType.BITCOIN_VOUT =>
        val r = BITCOIN_VOUT
        r
      case software.amazon.awssdk.services.managedblockchainquery.model.QueryTransactionEventType.INTERNAL_ETH_TRANSFER =>
        val r = INTERNAL_ETH_TRANSFER
        r
      case software.amazon.awssdk.services.managedblockchainquery.model.QueryTransactionEventType.ETH_TRANSFER =>
        val r = ETH_TRANSFER
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.managedblockchainquery.model.QueryTransactionEventType {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchainquery.model.QueryTransactionEventType =
      software.amazon.awssdk.services.managedblockchainquery.model.QueryTransactionEventType.UNKNOWN_TO_SDK_VERSION
  }
  case object ERC20_TRANSFER
      extends zio.aws.managedblockchainquery.model.QueryTransactionEventType {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchainquery.model.QueryTransactionEventType =
      software.amazon.awssdk.services.managedblockchainquery.model.QueryTransactionEventType.ERC20_TRANSFER
  }
  case object ERC20_MINT
      extends zio.aws.managedblockchainquery.model.QueryTransactionEventType {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchainquery.model.QueryTransactionEventType =
      software.amazon.awssdk.services.managedblockchainquery.model.QueryTransactionEventType.ERC20_MINT
  }
  case object ERC20_BURN
      extends zio.aws.managedblockchainquery.model.QueryTransactionEventType {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchainquery.model.QueryTransactionEventType =
      software.amazon.awssdk.services.managedblockchainquery.model.QueryTransactionEventType.ERC20_BURN
  }
  case object ERC20_DEPOSIT
      extends zio.aws.managedblockchainquery.model.QueryTransactionEventType {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchainquery.model.QueryTransactionEventType =
      software.amazon.awssdk.services.managedblockchainquery.model.QueryTransactionEventType.ERC20_DEPOSIT
  }
  case object ERC20_WITHDRAWAL
      extends zio.aws.managedblockchainquery.model.QueryTransactionEventType {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchainquery.model.QueryTransactionEventType =
      software.amazon.awssdk.services.managedblockchainquery.model.QueryTransactionEventType.ERC20_WITHDRAWAL
  }
  case object ERC721_TRANSFER
      extends zio.aws.managedblockchainquery.model.QueryTransactionEventType {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchainquery.model.QueryTransactionEventType =
      software.amazon.awssdk.services.managedblockchainquery.model.QueryTransactionEventType.ERC721_TRANSFER
  }
  case object ERC1155_TRANSFER
      extends zio.aws.managedblockchainquery.model.QueryTransactionEventType {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchainquery.model.QueryTransactionEventType =
      software.amazon.awssdk.services.managedblockchainquery.model.QueryTransactionEventType.ERC1155_TRANSFER
  }
  case object BITCOIN_VIN
      extends zio.aws.managedblockchainquery.model.QueryTransactionEventType {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchainquery.model.QueryTransactionEventType =
      software.amazon.awssdk.services.managedblockchainquery.model.QueryTransactionEventType.BITCOIN_VIN
  }
  case object BITCOIN_VOUT
      extends zio.aws.managedblockchainquery.model.QueryTransactionEventType {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchainquery.model.QueryTransactionEventType =
      software.amazon.awssdk.services.managedblockchainquery.model.QueryTransactionEventType.BITCOIN_VOUT
  }
  case object INTERNAL_ETH_TRANSFER
      extends zio.aws.managedblockchainquery.model.QueryTransactionEventType {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchainquery.model.QueryTransactionEventType =
      software.amazon.awssdk.services.managedblockchainquery.model.QueryTransactionEventType.INTERNAL_ETH_TRANSFER
  }
  case object ETH_TRANSFER
      extends zio.aws.managedblockchainquery.model.QueryTransactionEventType {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchainquery.model.QueryTransactionEventType =
      software.amazon.awssdk.services.managedblockchainquery.model.QueryTransactionEventType.ETH_TRANSFER
  }
}
