package zio.aws.managedblockchainquery.model
import scala.jdk.CollectionConverters.*
sealed trait QueryTokenStandard {
  def unwrap: software.amazon.awssdk.services.managedblockchainquery.model.QueryTokenStandard
}
object QueryTokenStandard {
  def wrap(
      value: software.amazon.awssdk.services.managedblockchainquery.model.QueryTokenStandard
  ): zio.aws.managedblockchainquery.model.QueryTokenStandard = value match {
    case software.amazon.awssdk.services.managedblockchainquery.model.QueryTokenStandard.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.managedblockchainquery.model.QueryTokenStandard.ERC20 =>
      val r = ERC20
      r
    case software.amazon.awssdk.services.managedblockchainquery.model.QueryTokenStandard.ERC721 =>
      val r = ERC721
      r
    case software.amazon.awssdk.services.managedblockchainquery.model.QueryTokenStandard.ERC1155 =>
      val r = ERC1155
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.managedblockchainquery.model.QueryTokenStandard {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchainquery.model.QueryTokenStandard =
      software.amazon.awssdk.services.managedblockchainquery.model.QueryTokenStandard.UNKNOWN_TO_SDK_VERSION
  }
  case object ERC20
      extends zio.aws.managedblockchainquery.model.QueryTokenStandard {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchainquery.model.QueryTokenStandard =
      software.amazon.awssdk.services.managedblockchainquery.model.QueryTokenStandard.ERC20
  }
  case object ERC721
      extends zio.aws.managedblockchainquery.model.QueryTokenStandard {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchainquery.model.QueryTokenStandard =
      software.amazon.awssdk.services.managedblockchainquery.model.QueryTokenStandard.ERC721
  }
  case object ERC1155
      extends zio.aws.managedblockchainquery.model.QueryTokenStandard {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchainquery.model.QueryTokenStandard =
      software.amazon.awssdk.services.managedblockchainquery.model.QueryTokenStandard.ERC1155
  }
}
