package zio.aws.managedblockchainquery.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchGetTokenBalanceErrorItem(
    tokenIdentifier: Optional[
      zio.aws.managedblockchainquery.model.TokenIdentifier
    ] = Optional.Absent,
    ownerIdentifier: Optional[
      zio.aws.managedblockchainquery.model.OwnerIdentifier
    ] = Optional.Absent,
    atBlockchainInstant: Optional[
      zio.aws.managedblockchainquery.model.BlockchainInstant
    ] = Optional.Absent,
    errorCode: String,
    errorMessage: String,
    errorType: zio.aws.managedblockchainquery.model.ErrorType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchainquery.model.BatchGetTokenBalanceErrorItem = {
    import BatchGetTokenBalanceErrorItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchainquery.model.BatchGetTokenBalanceErrorItem
      .builder()
      .optionallyWith(tokenIdentifier.map(value => value.buildAwsValue()))(
        _.tokenIdentifier
      )
      .optionallyWith(ownerIdentifier.map(value => value.buildAwsValue()))(
        _.ownerIdentifier
      )
      .optionallyWith(atBlockchainInstant.map(value => value.buildAwsValue()))(
        _.atBlockchainInstant
      )
      .errorCode(errorCode: java.lang.String)
      .errorMessage(errorMessage: java.lang.String)
      .errorType(errorType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchainquery.model.BatchGetTokenBalanceErrorItem.ReadOnly =
    zio.aws.managedblockchainquery.model.BatchGetTokenBalanceErrorItem
      .wrap(buildAwsValue())
}
object BatchGetTokenBalanceErrorItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchainquery.model.BatchGetTokenBalanceErrorItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.managedblockchainquery.model.BatchGetTokenBalanceErrorItem =
      zio.aws.managedblockchainquery.model.BatchGetTokenBalanceErrorItem(
        tokenIdentifier.map(value => value.asEditable),
        ownerIdentifier.map(value => value.asEditable),
        atBlockchainInstant.map(value => value.asEditable),
        errorCode,
        errorMessage,
        errorType
      )
    def tokenIdentifier: Optional[
      zio.aws.managedblockchainquery.model.TokenIdentifier.ReadOnly
    ]
    def ownerIdentifier: Optional[
      zio.aws.managedblockchainquery.model.OwnerIdentifier.ReadOnly
    ]
    def atBlockchainInstant: Optional[
      zio.aws.managedblockchainquery.model.BlockchainInstant.ReadOnly
    ]
    def errorCode: String
    def errorMessage: String
    def errorType: zio.aws.managedblockchainquery.model.ErrorType
    def getTokenIdentifier: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchainquery.model.TokenIdentifier.ReadOnly
    ] = AwsError.unwrapOptionField("tokenIdentifier", tokenIdentifier)
    def getOwnerIdentifier: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchainquery.model.OwnerIdentifier.ReadOnly
    ] = AwsError.unwrapOptionField("ownerIdentifier", ownerIdentifier)
    def getAtBlockchainInstant: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchainquery.model.BlockchainInstant.ReadOnly
    ] = AwsError.unwrapOptionField("atBlockchainInstant", atBlockchainInstant)
    def getErrorCode: ZIO[Any, Nothing, String] = ZIO.succeed(errorCode)
    def getErrorMessage: ZIO[Any, Nothing, String] = ZIO.succeed(errorMessage)
    def getErrorType
        : ZIO[Any, Nothing, zio.aws.managedblockchainquery.model.ErrorType] =
      ZIO.succeed(errorType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.BatchGetTokenBalanceErrorItem
  ) extends zio.aws.managedblockchainquery.model.BatchGetTokenBalanceErrorItem.ReadOnly {
    override val tokenIdentifier: Optional[
      zio.aws.managedblockchainquery.model.TokenIdentifier.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.tokenIdentifier())
      .map(value =>
        zio.aws.managedblockchainquery.model.TokenIdentifier.wrap(value)
      )
    override val ownerIdentifier: Optional[
      zio.aws.managedblockchainquery.model.OwnerIdentifier.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerIdentifier())
      .map(value =>
        zio.aws.managedblockchainquery.model.OwnerIdentifier.wrap(value)
      )
    override val atBlockchainInstant: Optional[
      zio.aws.managedblockchainquery.model.BlockchainInstant.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.atBlockchainInstant())
      .map(value =>
        zio.aws.managedblockchainquery.model.BlockchainInstant.wrap(value)
      )
    override val errorCode: String = impl.errorCode(): String
    override val errorMessage: String = impl.errorMessage(): String
    override val errorType: zio.aws.managedblockchainquery.model.ErrorType =
      zio.aws.managedblockchainquery.model.ErrorType.wrap(impl.errorType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.BatchGetTokenBalanceErrorItem
  ): zio.aws.managedblockchainquery.model.BatchGetTokenBalanceErrorItem.ReadOnly =
    new Wrapper(impl)
}
