package zio.aws.managedblockchainquery.model
import scala.jdk.CollectionConverters.*
sealed trait QueryNetwork {
  def unwrap: software.amazon.awssdk.services.managedblockchainquery.model.QueryNetwork
}
object QueryNetwork {
  def wrap(
      value: software.amazon.awssdk.services.managedblockchainquery.model.QueryNetwork
  ): zio.aws.managedblockchainquery.model.QueryNetwork = value match {
    case software.amazon.awssdk.services.managedblockchainquery.model.QueryNetwork.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.managedblockchainquery.model.QueryNetwork.ETHEREUM_MAINNET =>
      val r = ETHEREUM_MAINNET
      r
    case software.amazon.awssdk.services.managedblockchainquery.model.QueryNetwork.BITCOIN_MAINNET =>
      val r = BITCOIN_MAINNET
      r
    case software.amazon.awssdk.services.managedblockchainquery.model.QueryNetwork.BITCOIN_TESTNET =>
      val r = BITCOIN_TESTNET
      r
    case software.amazon.awssdk.services.managedblockchainquery.model.QueryNetwork.ETHEREUM_SEPOLIA_TESTNET =>
      val r = ETHEREUM_SEPOLIA_TESTNET
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.managedblockchainquery.model.QueryNetwork {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchainquery.model.QueryNetwork =
      software.amazon.awssdk.services.managedblockchainquery.model.QueryNetwork.UNKNOWN_TO_SDK_VERSION
  }
  case object ETHEREUM_MAINNET
      extends zio.aws.managedblockchainquery.model.QueryNetwork {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchainquery.model.QueryNetwork =
      software.amazon.awssdk.services.managedblockchainquery.model.QueryNetwork.ETHEREUM_MAINNET
  }
  case object BITCOIN_MAINNET
      extends zio.aws.managedblockchainquery.model.QueryNetwork {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchainquery.model.QueryNetwork =
      software.amazon.awssdk.services.managedblockchainquery.model.QueryNetwork.BITCOIN_MAINNET
  }
  case object BITCOIN_TESTNET
      extends zio.aws.managedblockchainquery.model.QueryNetwork {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchainquery.model.QueryNetwork =
      software.amazon.awssdk.services.managedblockchainquery.model.QueryNetwork.BITCOIN_TESTNET
  }
  case object ETHEREUM_SEPOLIA_TESTNET
      extends zio.aws.managedblockchainquery.model.QueryNetwork {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchainquery.model.QueryNetwork =
      software.amazon.awssdk.services.managedblockchainquery.model.QueryNetwork.ETHEREUM_SEPOLIA_TESTNET
  }
}
