package zio.aws.managedblockchainquery.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.managedblockchainquery.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListTransactionEventsResponse(
    events: Iterable[zio.aws.managedblockchainquery.model.TransactionEvent],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionEventsResponse = {
    import ListTransactionEventsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionEventsResponse
      .builder()
      .events(events.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchainquery.model.ListTransactionEventsResponse.ReadOnly =
    zio.aws.managedblockchainquery.model.ListTransactionEventsResponse
      .wrap(buildAwsValue())
}
object ListTransactionEventsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionEventsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.managedblockchainquery.model.ListTransactionEventsResponse =
      zio.aws.managedblockchainquery.model.ListTransactionEventsResponse(
        events.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def events
        : List[zio.aws.managedblockchainquery.model.TransactionEvent.ReadOnly]
    def nextToken: Optional[NextToken]
    def getEvents: ZIO[Any, Nothing, List[
      zio.aws.managedblockchainquery.model.TransactionEvent.ReadOnly
    ]] = ZIO.succeed(events)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionEventsResponse
  ) extends zio.aws.managedblockchainquery.model.ListTransactionEventsResponse.ReadOnly {
    override val events
        : List[zio.aws.managedblockchainquery.model.TransactionEvent.ReadOnly] =
      impl
        .events()
        .asScala
        .map { item =>
          zio.aws.managedblockchainquery.model.TransactionEvent.wrap(item)
        }
        .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.managedblockchainquery.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionEventsResponse
  ): zio.aws.managedblockchainquery.model.ListTransactionEventsResponse.ReadOnly =
    new Wrapper(impl)
}
