package zio.aws.managedblockchainquery.model
import zio.aws.managedblockchainquery.model.primitives.{
  ListTokenBalancesInputMaxResultsInteger,
  NextToken
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListTokenBalancesRequest(
    ownerFilter: Optional[zio.aws.managedblockchainquery.model.OwnerFilter] =
      Optional.Absent,
    tokenFilter: zio.aws.managedblockchainquery.model.TokenFilter,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[ListTokenBalancesInputMaxResultsInteger] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchainquery.model.ListTokenBalancesRequest = {
    import ListTokenBalancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchainquery.model.ListTokenBalancesRequest
      .builder()
      .optionallyWith(ownerFilter.map(value => value.buildAwsValue()))(
        _.ownerFilter
      )
      .tokenFilter(tokenFilter.buildAwsValue())
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          ListTokenBalancesInputMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchainquery.model.ListTokenBalancesRequest.ReadOnly =
    zio.aws.managedblockchainquery.model.ListTokenBalancesRequest
      .wrap(buildAwsValue())
}
object ListTokenBalancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchainquery.model.ListTokenBalancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.managedblockchainquery.model.ListTokenBalancesRequest =
      zio.aws.managedblockchainquery.model.ListTokenBalancesRequest(
        ownerFilter.map(value => value.asEditable),
        tokenFilter.asEditable,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def ownerFilter
        : Optional[zio.aws.managedblockchainquery.model.OwnerFilter.ReadOnly]
    def tokenFilter: zio.aws.managedblockchainquery.model.TokenFilter.ReadOnly
    def nextToken: Optional[NextToken]
    def maxResults: Optional[ListTokenBalancesInputMaxResultsInteger]
    def getOwnerFilter: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchainquery.model.OwnerFilter.ReadOnly
    ] = AwsError.unwrapOptionField("ownerFilter", ownerFilter)
    def getTokenFilter: ZIO[
      Any,
      Nothing,
      zio.aws.managedblockchainquery.model.TokenFilter.ReadOnly
    ] = ZIO.succeed(tokenFilter)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults
        : ZIO[Any, AwsError, ListTokenBalancesInputMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.ListTokenBalancesRequest
  ) extends zio.aws.managedblockchainquery.model.ListTokenBalancesRequest.ReadOnly {
    override val ownerFilter
        : Optional[zio.aws.managedblockchainquery.model.OwnerFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ownerFilter())
        .map(value =>
          zio.aws.managedblockchainquery.model.OwnerFilter.wrap(value)
        )
    override val tokenFilter
        : zio.aws.managedblockchainquery.model.TokenFilter.ReadOnly =
      zio.aws.managedblockchainquery.model.TokenFilter.wrap(impl.tokenFilter())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.managedblockchainquery.model.primitives.NextToken(value)
      )
    override val maxResults: Optional[ListTokenBalancesInputMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.managedblockchainquery.model.primitives
            .ListTokenBalancesInputMaxResultsInteger(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.ListTokenBalancesRequest
  ): zio.aws.managedblockchainquery.model.ListTokenBalancesRequest.ReadOnly =
    new Wrapper(impl)
}
