package zio.aws.managedblockchainquery.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.managedblockchainquery.model.primitives.ChainAddress
import scala.jdk.CollectionConverters.*
final case class GetAssetContractResponse(
    contractIdentifier: zio.aws.managedblockchainquery.model.ContractIdentifier,
    tokenStandard: zio.aws.managedblockchainquery.model.QueryTokenStandard,
    deployerAddress: ChainAddress,
    metadata: Optional[zio.aws.managedblockchainquery.model.ContractMetadata] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchainquery.model.GetAssetContractResponse = {
    import GetAssetContractResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchainquery.model.GetAssetContractResponse
      .builder()
      .contractIdentifier(contractIdentifier.buildAwsValue())
      .tokenStandard(tokenStandard.unwrap)
      .deployerAddress(ChainAddress.unwrap(deployerAddress): java.lang.String)
      .optionallyWith(metadata.map(value => value.buildAwsValue()))(_.metadata)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchainquery.model.GetAssetContractResponse.ReadOnly =
    zio.aws.managedblockchainquery.model.GetAssetContractResponse
      .wrap(buildAwsValue())
}
object GetAssetContractResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchainquery.model.GetAssetContractResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.managedblockchainquery.model.GetAssetContractResponse =
      zio.aws.managedblockchainquery.model.GetAssetContractResponse(
        contractIdentifier.asEditable,
        tokenStandard,
        deployerAddress,
        metadata.map(value => value.asEditable)
      )
    def contractIdentifier
        : zio.aws.managedblockchainquery.model.ContractIdentifier.ReadOnly
    def tokenStandard: zio.aws.managedblockchainquery.model.QueryTokenStandard
    def deployerAddress: ChainAddress
    def metadata: Optional[
      zio.aws.managedblockchainquery.model.ContractMetadata.ReadOnly
    ]
    def getContractIdentifier: ZIO[
      Any,
      Nothing,
      zio.aws.managedblockchainquery.model.ContractIdentifier.ReadOnly
    ] = ZIO.succeed(contractIdentifier)
    def getTokenStandard: ZIO[
      Any,
      Nothing,
      zio.aws.managedblockchainquery.model.QueryTokenStandard
    ] = ZIO.succeed(tokenStandard)
    def getDeployerAddress: ZIO[Any, Nothing, ChainAddress] =
      ZIO.succeed(deployerAddress)
    def getMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchainquery.model.ContractMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("metadata", metadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.GetAssetContractResponse
  ) extends zio.aws.managedblockchainquery.model.GetAssetContractResponse.ReadOnly {
    override val contractIdentifier
        : zio.aws.managedblockchainquery.model.ContractIdentifier.ReadOnly =
      zio.aws.managedblockchainquery.model.ContractIdentifier
        .wrap(impl.contractIdentifier())
    override val tokenStandard
        : zio.aws.managedblockchainquery.model.QueryTokenStandard =
      zio.aws.managedblockchainquery.model.QueryTokenStandard
        .wrap(impl.tokenStandard())
    override val deployerAddress: ChainAddress =
      zio.aws.managedblockchainquery.model.primitives
        .ChainAddress(impl.deployerAddress())
    override val metadata: Optional[
      zio.aws.managedblockchainquery.model.ContractMetadata.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.metadata())
      .map(value =>
        zio.aws.managedblockchainquery.model.ContractMetadata.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.GetAssetContractResponse
  ): zio.aws.managedblockchainquery.model.GetAssetContractResponse.ReadOnly =
    new Wrapper(impl)
}
