package zio.aws.managedblockchainquery.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchGetTokenBalanceRequest(
    getTokenBalanceInputs: Optional[Iterable[
      zio.aws.managedblockchainquery.model.BatchGetTokenBalanceInputItem
    ]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchainquery.model.BatchGetTokenBalanceRequest = {
    import BatchGetTokenBalanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchainquery.model.BatchGetTokenBalanceRequest
      .builder()
      .optionallyWith(
        getTokenBalanceInputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.getTokenBalanceInputs)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchainquery.model.BatchGetTokenBalanceRequest.ReadOnly =
    zio.aws.managedblockchainquery.model.BatchGetTokenBalanceRequest
      .wrap(buildAwsValue())
}
object BatchGetTokenBalanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchainquery.model.BatchGetTokenBalanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.managedblockchainquery.model.BatchGetTokenBalanceRequest =
      zio.aws.managedblockchainquery.model.BatchGetTokenBalanceRequest(
        getTokenBalanceInputs.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def getTokenBalanceInputs: Optional[List[
      zio.aws.managedblockchainquery.model.BatchGetTokenBalanceInputItem.ReadOnly
    ]]
    def getGetTokenBalanceInputs: ZIO[Any, AwsError, List[
      zio.aws.managedblockchainquery.model.BatchGetTokenBalanceInputItem.ReadOnly
    ]] =
      AwsError.unwrapOptionField("getTokenBalanceInputs", getTokenBalanceInputs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.BatchGetTokenBalanceRequest
  ) extends zio.aws.managedblockchainquery.model.BatchGetTokenBalanceRequest.ReadOnly {
    override val getTokenBalanceInputs: Optional[List[
      zio.aws.managedblockchainquery.model.BatchGetTokenBalanceInputItem.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.getTokenBalanceInputs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.managedblockchainquery.model.BatchGetTokenBalanceInputItem
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.BatchGetTokenBalanceRequest
  ): zio.aws.managedblockchainquery.model.BatchGetTokenBalanceRequest.ReadOnly =
    new Wrapper(impl)
}
