package zio.aws.managedblockchainquery.model
import zio.aws.managedblockchainquery.model.primitives.{
  ListAssetContractsInputMaxResultsInteger,
  NextToken
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListAssetContractsRequest(
    contractFilter: zio.aws.managedblockchainquery.model.ContractFilter,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[ListAssetContractsInputMaxResultsInteger] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchainquery.model.ListAssetContractsRequest = {
    import ListAssetContractsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchainquery.model.ListAssetContractsRequest
      .builder()
      .contractFilter(contractFilter.buildAwsValue())
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          ListAssetContractsInputMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchainquery.model.ListAssetContractsRequest.ReadOnly =
    zio.aws.managedblockchainquery.model.ListAssetContractsRequest
      .wrap(buildAwsValue())
}
object ListAssetContractsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchainquery.model.ListAssetContractsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.managedblockchainquery.model.ListAssetContractsRequest =
      zio.aws.managedblockchainquery.model.ListAssetContractsRequest(
        contractFilter.asEditable,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def contractFilter
        : zio.aws.managedblockchainquery.model.ContractFilter.ReadOnly
    def nextToken: Optional[NextToken]
    def maxResults: Optional[ListAssetContractsInputMaxResultsInteger]
    def getContractFilter: ZIO[
      Any,
      Nothing,
      zio.aws.managedblockchainquery.model.ContractFilter.ReadOnly
    ] = ZIO.succeed(contractFilter)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults
        : ZIO[Any, AwsError, ListAssetContractsInputMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.ListAssetContractsRequest
  ) extends zio.aws.managedblockchainquery.model.ListAssetContractsRequest.ReadOnly {
    override val contractFilter
        : zio.aws.managedblockchainquery.model.ContractFilter.ReadOnly =
      zio.aws.managedblockchainquery.model.ContractFilter
        .wrap(impl.contractFilter())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.managedblockchainquery.model.primitives.NextToken(value)
      )
    override val maxResults
        : Optional[ListAssetContractsInputMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.managedblockchainquery.model.primitives
            .ListAssetContractsInputMaxResultsInteger(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.ListAssetContractsRequest
  ): zio.aws.managedblockchainquery.model.ListAssetContractsRequest.ReadOnly =
    new Wrapper(impl)
}
