package zio.aws.managedblockchainquery.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.managedblockchainquery.model.primitives.ChainAddress
import scala.jdk.CollectionConverters.*
final case class ContractIdentifier(
    network: zio.aws.managedblockchainquery.model.QueryNetwork,
    contractAddress: ChainAddress
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchainquery.model.ContractIdentifier = {
    import ContractIdentifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchainquery.model.ContractIdentifier
      .builder()
      .network(network.unwrap)
      .contractAddress(ChainAddress.unwrap(contractAddress): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchainquery.model.ContractIdentifier.ReadOnly =
    zio.aws.managedblockchainquery.model.ContractIdentifier
      .wrap(buildAwsValue())
}
object ContractIdentifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchainquery.model.ContractIdentifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchainquery.model.ContractIdentifier =
      zio.aws.managedblockchainquery.model
        .ContractIdentifier(network, contractAddress)
    def network: zio.aws.managedblockchainquery.model.QueryNetwork
    def contractAddress: ChainAddress
    def getNetwork
        : ZIO[Any, Nothing, zio.aws.managedblockchainquery.model.QueryNetwork] =
      ZIO.succeed(network)
    def getContractAddress: ZIO[Any, Nothing, ChainAddress] =
      ZIO.succeed(contractAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.ContractIdentifier
  ) extends zio.aws.managedblockchainquery.model.ContractIdentifier.ReadOnly {
    override val network: zio.aws.managedblockchainquery.model.QueryNetwork =
      zio.aws.managedblockchainquery.model.QueryNetwork.wrap(impl.network())
    override val contractAddress: ChainAddress =
      zio.aws.managedblockchainquery.model.primitives
        .ChainAddress(impl.contractAddress())
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.ContractIdentifier
  ): zio.aws.managedblockchainquery.model.ContractIdentifier.ReadOnly =
    new Wrapper(impl)
}
