package zio.aws.managedblockchainquery.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TokenBalance(
    ownerIdentifier: Optional[
      zio.aws.managedblockchainquery.model.OwnerIdentifier
    ] = Optional.Absent,
    tokenIdentifier: Optional[
      zio.aws.managedblockchainquery.model.TokenIdentifier
    ] = Optional.Absent,
    balance: String,
    atBlockchainInstant: zio.aws.managedblockchainquery.model.BlockchainInstant,
    lastUpdatedTime: Optional[
      zio.aws.managedblockchainquery.model.BlockchainInstant
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchainquery.model.TokenBalance = {
    import TokenBalance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchainquery.model.TokenBalance
      .builder()
      .optionallyWith(ownerIdentifier.map(value => value.buildAwsValue()))(
        _.ownerIdentifier
      )
      .optionallyWith(tokenIdentifier.map(value => value.buildAwsValue()))(
        _.tokenIdentifier
      )
      .balance(balance: java.lang.String)
      .atBlockchainInstant(atBlockchainInstant.buildAwsValue())
      .optionallyWith(lastUpdatedTime.map(value => value.buildAwsValue()))(
        _.lastUpdatedTime
      )
      .build()
  }
  def asReadOnly: zio.aws.managedblockchainquery.model.TokenBalance.ReadOnly =
    zio.aws.managedblockchainquery.model.TokenBalance.wrap(buildAwsValue())
}
object TokenBalance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchainquery.model.TokenBalance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchainquery.model.TokenBalance =
      zio.aws.managedblockchainquery.model.TokenBalance(
        ownerIdentifier.map(value => value.asEditable),
        tokenIdentifier.map(value => value.asEditable),
        balance,
        atBlockchainInstant.asEditable,
        lastUpdatedTime.map(value => value.asEditable)
      )
    def ownerIdentifier: Optional[
      zio.aws.managedblockchainquery.model.OwnerIdentifier.ReadOnly
    ]
    def tokenIdentifier: Optional[
      zio.aws.managedblockchainquery.model.TokenIdentifier.ReadOnly
    ]
    def balance: String
    def atBlockchainInstant
        : zio.aws.managedblockchainquery.model.BlockchainInstant.ReadOnly
    def lastUpdatedTime: Optional[
      zio.aws.managedblockchainquery.model.BlockchainInstant.ReadOnly
    ]
    def getOwnerIdentifier: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchainquery.model.OwnerIdentifier.ReadOnly
    ] = AwsError.unwrapOptionField("ownerIdentifier", ownerIdentifier)
    def getTokenIdentifier: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchainquery.model.TokenIdentifier.ReadOnly
    ] = AwsError.unwrapOptionField("tokenIdentifier", tokenIdentifier)
    def getBalance: ZIO[Any, Nothing, String] = ZIO.succeed(balance)
    def getAtBlockchainInstant: ZIO[
      Any,
      Nothing,
      zio.aws.managedblockchainquery.model.BlockchainInstant.ReadOnly
    ] = ZIO.succeed(atBlockchainInstant)
    def getLastUpdatedTime: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchainquery.model.BlockchainInstant.ReadOnly
    ] = AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.TokenBalance
  ) extends zio.aws.managedblockchainquery.model.TokenBalance.ReadOnly {
    override val ownerIdentifier: Optional[
      zio.aws.managedblockchainquery.model.OwnerIdentifier.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerIdentifier())
      .map(value =>
        zio.aws.managedblockchainquery.model.OwnerIdentifier.wrap(value)
      )
    override val tokenIdentifier: Optional[
      zio.aws.managedblockchainquery.model.TokenIdentifier.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.tokenIdentifier())
      .map(value =>
        zio.aws.managedblockchainquery.model.TokenIdentifier.wrap(value)
      )
    override val balance: String = impl.balance(): String
    override val atBlockchainInstant
        : zio.aws.managedblockchainquery.model.BlockchainInstant.ReadOnly =
      zio.aws.managedblockchainquery.model.BlockchainInstant
        .wrap(impl.atBlockchainInstant())
    override val lastUpdatedTime: Optional[
      zio.aws.managedblockchainquery.model.BlockchainInstant.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedTime())
      .map(value =>
        zio.aws.managedblockchainquery.model.BlockchainInstant.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.TokenBalance
  ): zio.aws.managedblockchainquery.model.TokenBalance.ReadOnly = new Wrapper(
    impl
  )
}
