package zio.aws.managedblockchainquery.model
import zio.aws.managedblockchainquery.model.primitives.{
  ListTransactionsInputMaxResultsInteger,
  NextToken,
  ChainAddress
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListTransactionsRequest(
    address: ChainAddress,
    network: zio.aws.managedblockchainquery.model.QueryNetwork,
    fromBlockchainInstant: Optional[
      zio.aws.managedblockchainquery.model.BlockchainInstant
    ] = Optional.Absent,
    toBlockchainInstant: Optional[
      zio.aws.managedblockchainquery.model.BlockchainInstant
    ] = Optional.Absent,
    sort: Optional[zio.aws.managedblockchainquery.model.ListTransactionsSort] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[ListTransactionsInputMaxResultsInteger] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionsRequest = {
    import ListTransactionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionsRequest
      .builder()
      .address(ChainAddress.unwrap(address): java.lang.String)
      .network(network.unwrap)
      .optionallyWith(
        fromBlockchainInstant.map(value => value.buildAwsValue())
      )(_.fromBlockchainInstant)
      .optionallyWith(toBlockchainInstant.map(value => value.buildAwsValue()))(
        _.toBlockchainInstant
      )
      .optionallyWith(sort.map(value => value.buildAwsValue()))(_.sort)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          ListTransactionsInputMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchainquery.model.ListTransactionsRequest.ReadOnly =
    zio.aws.managedblockchainquery.model.ListTransactionsRequest
      .wrap(buildAwsValue())
}
object ListTransactionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.managedblockchainquery.model.ListTransactionsRequest =
      zio.aws.managedblockchainquery.model.ListTransactionsRequest(
        address,
        network,
        fromBlockchainInstant.map(value => value.asEditable),
        toBlockchainInstant.map(value => value.asEditable),
        sort.map(value => value.asEditable),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def address: ChainAddress
    def network: zio.aws.managedblockchainquery.model.QueryNetwork
    def fromBlockchainInstant: Optional[
      zio.aws.managedblockchainquery.model.BlockchainInstant.ReadOnly
    ]
    def toBlockchainInstant: Optional[
      zio.aws.managedblockchainquery.model.BlockchainInstant.ReadOnly
    ]
    def sort: Optional[
      zio.aws.managedblockchainquery.model.ListTransactionsSort.ReadOnly
    ]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[ListTransactionsInputMaxResultsInteger]
    def getAddress: ZIO[Any, Nothing, ChainAddress] = ZIO.succeed(address)
    def getNetwork
        : ZIO[Any, Nothing, zio.aws.managedblockchainquery.model.QueryNetwork] =
      ZIO.succeed(network)
    def getFromBlockchainInstant: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchainquery.model.BlockchainInstant.ReadOnly
    ] =
      AwsError.unwrapOptionField("fromBlockchainInstant", fromBlockchainInstant)
    def getToBlockchainInstant: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchainquery.model.BlockchainInstant.ReadOnly
    ] = AwsError.unwrapOptionField("toBlockchainInstant", toBlockchainInstant)
    def getSort: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchainquery.model.ListTransactionsSort.ReadOnly
    ] = AwsError.unwrapOptionField("sort", sort)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults
        : ZIO[Any, AwsError, ListTransactionsInputMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionsRequest
  ) extends zio.aws.managedblockchainquery.model.ListTransactionsRequest.ReadOnly {
    override val address: ChainAddress =
      zio.aws.managedblockchainquery.model.primitives
        .ChainAddress(impl.address())
    override val network: zio.aws.managedblockchainquery.model.QueryNetwork =
      zio.aws.managedblockchainquery.model.QueryNetwork.wrap(impl.network())
    override val fromBlockchainInstant: Optional[
      zio.aws.managedblockchainquery.model.BlockchainInstant.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.fromBlockchainInstant())
      .map(value =>
        zio.aws.managedblockchainquery.model.BlockchainInstant.wrap(value)
      )
    override val toBlockchainInstant: Optional[
      zio.aws.managedblockchainquery.model.BlockchainInstant.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.toBlockchainInstant())
      .map(value =>
        zio.aws.managedblockchainquery.model.BlockchainInstant.wrap(value)
      )
    override val sort: Optional[
      zio.aws.managedblockchainquery.model.ListTransactionsSort.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sort())
      .map(value =>
        zio.aws.managedblockchainquery.model.ListTransactionsSort.wrap(value)
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.managedblockchainquery.model.primitives.NextToken(value)
      )
    override val maxResults: Optional[ListTransactionsInputMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.managedblockchainquery.model.primitives
            .ListTransactionsInputMaxResultsInteger(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionsRequest
  ): zio.aws.managedblockchainquery.model.ListTransactionsRequest.ReadOnly =
    new Wrapper(impl)
}
