package zio.aws.managedblockchainquery.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.managedblockchainquery.model.primitives.{
  Integer,
  QueryTokenId,
  ChainAddress,
  QueryTransactionHash
}
import scala.jdk.CollectionConverters._
final case class TransactionEvent(
    network: zio.aws.managedblockchainquery.model.QueryNetwork,
    transactionHash: QueryTransactionHash,
    eventType: zio.aws.managedblockchainquery.model.QueryTransactionEventType,
    from: Optional[ChainAddress] = Optional.Absent,
    to: Optional[ChainAddress] = Optional.Absent,
    value: Optional[String] = Optional.Absent,
    contractAddress: Optional[ChainAddress] = Optional.Absent,
    tokenId: Optional[QueryTokenId] = Optional.Absent,
    transactionId: Optional[String] = Optional.Absent,
    voutIndex: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchainquery.model.TransactionEvent = {
    import TransactionEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchainquery.model.TransactionEvent
      .builder()
      .network(network.unwrap)
      .transactionHash(
        QueryTransactionHash.unwrap(transactionHash): java.lang.String
      )
      .eventType(eventType.unwrap)
      .optionallyWith(
        from.map(value => ChainAddress.unwrap(value): java.lang.String)
      )(_.from)
      .optionallyWith(
        to.map(value => ChainAddress.unwrap(value): java.lang.String)
      )(_.to)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .optionallyWith(
        contractAddress.map(value =>
          ChainAddress.unwrap(value): java.lang.String
        )
      )(_.contractAddress)
      .optionallyWith(
        tokenId.map(value => QueryTokenId.unwrap(value): java.lang.String)
      )(_.tokenId)
      .optionallyWith(transactionId.map(value => value: java.lang.String))(
        _.transactionId
      )
      .optionallyWith(voutIndex.map(value => value: java.lang.Integer))(
        _.voutIndex
      )
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchainquery.model.TransactionEvent.ReadOnly =
    zio.aws.managedblockchainquery.model.TransactionEvent.wrap(buildAwsValue())
}
object TransactionEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchainquery.model.TransactionEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchainquery.model.TransactionEvent =
      zio.aws.managedblockchainquery.model.TransactionEvent(
        network,
        transactionHash,
        eventType,
        from.map(value => value),
        to.map(value => value),
        value.map(value => value),
        contractAddress.map(value => value),
        tokenId.map(value => value),
        transactionId.map(value => value),
        voutIndex.map(value => value)
      )
    def network: zio.aws.managedblockchainquery.model.QueryNetwork
    def transactionHash: QueryTransactionHash
    def eventType
        : zio.aws.managedblockchainquery.model.QueryTransactionEventType
    def from: Optional[ChainAddress]
    def to: Optional[ChainAddress]
    def value: Optional[String]
    def contractAddress: Optional[ChainAddress]
    def tokenId: Optional[QueryTokenId]
    def transactionId: Optional[String]
    def voutIndex: Optional[Integer]
    def getNetwork
        : ZIO[Any, Nothing, zio.aws.managedblockchainquery.model.QueryNetwork] =
      ZIO.succeed(network)
    def getTransactionHash: ZIO[Any, Nothing, QueryTransactionHash] =
      ZIO.succeed(transactionHash)
    def getEventType: ZIO[
      Any,
      Nothing,
      zio.aws.managedblockchainquery.model.QueryTransactionEventType
    ] = ZIO.succeed(eventType)
    def getFrom: ZIO[Any, AwsError, ChainAddress] =
      AwsError.unwrapOptionField("from", from)
    def getTo: ZIO[Any, AwsError, ChainAddress] =
      AwsError.unwrapOptionField("to", to)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
    def getContractAddress: ZIO[Any, AwsError, ChainAddress] =
      AwsError.unwrapOptionField("contractAddress", contractAddress)
    def getTokenId: ZIO[Any, AwsError, QueryTokenId] =
      AwsError.unwrapOptionField("tokenId", tokenId)
    def getTransactionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("transactionId", transactionId)
    def getVoutIndex: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("voutIndex", voutIndex)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.TransactionEvent
  ) extends zio.aws.managedblockchainquery.model.TransactionEvent.ReadOnly {
    override val network: zio.aws.managedblockchainquery.model.QueryNetwork =
      zio.aws.managedblockchainquery.model.QueryNetwork.wrap(impl.network())
    override val transactionHash: QueryTransactionHash =
      zio.aws.managedblockchainquery.model.primitives
        .QueryTransactionHash(impl.transactionHash())
    override val eventType
        : zio.aws.managedblockchainquery.model.QueryTransactionEventType =
      zio.aws.managedblockchainquery.model.QueryTransactionEventType
        .wrap(impl.eventType())
    override val from: Optional[ChainAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.from())
      .map(value =>
        zio.aws.managedblockchainquery.model.primitives.ChainAddress(value)
      )
    override val to: Optional[ChainAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.to())
      .map(value =>
        zio.aws.managedblockchainquery.model.primitives.ChainAddress(value)
      )
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
    override val contractAddress: Optional[ChainAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.contractAddress())
      .map(value =>
        zio.aws.managedblockchainquery.model.primitives.ChainAddress(value)
      )
    override val tokenId: Optional[QueryTokenId] = zio.aws.core.internal
      .optionalFromNullable(impl.tokenId())
      .map(value =>
        zio.aws.managedblockchainquery.model.primitives.QueryTokenId(value)
      )
    override val transactionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.transactionId())
      .map(value => value: String)
    override val voutIndex: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.voutIndex())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.TransactionEvent
  ): zio.aws.managedblockchainquery.model.TransactionEvent.ReadOnly =
    new Wrapper(impl)
}
