package zio.aws.managedblockchainquery.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetTokenBalanceRequest(
    tokenIdentifier: zio.aws.managedblockchainquery.model.TokenIdentifier,
    ownerIdentifier: zio.aws.managedblockchainquery.model.OwnerIdentifier,
    atBlockchainInstant: Optional[
      zio.aws.managedblockchainquery.model.BlockchainInstant
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchainquery.model.GetTokenBalanceRequest = {
    import GetTokenBalanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchainquery.model.GetTokenBalanceRequest
      .builder()
      .tokenIdentifier(tokenIdentifier.buildAwsValue())
      .ownerIdentifier(ownerIdentifier.buildAwsValue())
      .optionallyWith(atBlockchainInstant.map(value => value.buildAwsValue()))(
        _.atBlockchainInstant
      )
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchainquery.model.GetTokenBalanceRequest.ReadOnly =
    zio.aws.managedblockchainquery.model.GetTokenBalanceRequest
      .wrap(buildAwsValue())
}
object GetTokenBalanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchainquery.model.GetTokenBalanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.managedblockchainquery.model.GetTokenBalanceRequest =
      zio.aws.managedblockchainquery.model.GetTokenBalanceRequest(
        tokenIdentifier.asEditable,
        ownerIdentifier.asEditable,
        atBlockchainInstant.map(value => value.asEditable)
      )
    def tokenIdentifier
        : zio.aws.managedblockchainquery.model.TokenIdentifier.ReadOnly
    def ownerIdentifier
        : zio.aws.managedblockchainquery.model.OwnerIdentifier.ReadOnly
    def atBlockchainInstant: Optional[
      zio.aws.managedblockchainquery.model.BlockchainInstant.ReadOnly
    ]
    def getTokenIdentifier: ZIO[
      Any,
      Nothing,
      zio.aws.managedblockchainquery.model.TokenIdentifier.ReadOnly
    ] = ZIO.succeed(tokenIdentifier)
    def getOwnerIdentifier: ZIO[
      Any,
      Nothing,
      zio.aws.managedblockchainquery.model.OwnerIdentifier.ReadOnly
    ] = ZIO.succeed(ownerIdentifier)
    def getAtBlockchainInstant: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchainquery.model.BlockchainInstant.ReadOnly
    ] = AwsError.unwrapOptionField("atBlockchainInstant", atBlockchainInstant)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.GetTokenBalanceRequest
  ) extends zio.aws.managedblockchainquery.model.GetTokenBalanceRequest.ReadOnly {
    override val tokenIdentifier
        : zio.aws.managedblockchainquery.model.TokenIdentifier.ReadOnly =
      zio.aws.managedblockchainquery.model.TokenIdentifier
        .wrap(impl.tokenIdentifier())
    override val ownerIdentifier
        : zio.aws.managedblockchainquery.model.OwnerIdentifier.ReadOnly =
      zio.aws.managedblockchainquery.model.OwnerIdentifier
        .wrap(impl.ownerIdentifier())
    override val atBlockchainInstant: Optional[
      zio.aws.managedblockchainquery.model.BlockchainInstant.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.atBlockchainInstant())
      .map(value =>
        zio.aws.managedblockchainquery.model.BlockchainInstant.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.GetTokenBalanceRequest
  ): zio.aws.managedblockchainquery.model.GetTokenBalanceRequest.ReadOnly =
    new Wrapper(impl)
}
