package zio.aws.managedblockchainquery.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchGetTokenBalanceInputItem(
    tokenIdentifier: zio.aws.managedblockchainquery.model.TokenIdentifier,
    ownerIdentifier: zio.aws.managedblockchainquery.model.OwnerIdentifier,
    atBlockchainInstant: Optional[
      zio.aws.managedblockchainquery.model.BlockchainInstant
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchainquery.model.BatchGetTokenBalanceInputItem = {
    import BatchGetTokenBalanceInputItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchainquery.model.BatchGetTokenBalanceInputItem
      .builder()
      .tokenIdentifier(tokenIdentifier.buildAwsValue())
      .ownerIdentifier(ownerIdentifier.buildAwsValue())
      .optionallyWith(atBlockchainInstant.map(value => value.buildAwsValue()))(
        _.atBlockchainInstant
      )
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchainquery.model.BatchGetTokenBalanceInputItem.ReadOnly =
    zio.aws.managedblockchainquery.model.BatchGetTokenBalanceInputItem
      .wrap(buildAwsValue())
}
object BatchGetTokenBalanceInputItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchainquery.model.BatchGetTokenBalanceInputItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.managedblockchainquery.model.BatchGetTokenBalanceInputItem =
      zio.aws.managedblockchainquery.model.BatchGetTokenBalanceInputItem(
        tokenIdentifier.asEditable,
        ownerIdentifier.asEditable,
        atBlockchainInstant.map(value => value.asEditable)
      )
    def tokenIdentifier
        : zio.aws.managedblockchainquery.model.TokenIdentifier.ReadOnly
    def ownerIdentifier
        : zio.aws.managedblockchainquery.model.OwnerIdentifier.ReadOnly
    def atBlockchainInstant: Optional[
      zio.aws.managedblockchainquery.model.BlockchainInstant.ReadOnly
    ]
    def getTokenIdentifier: ZIO[
      Any,
      Nothing,
      zio.aws.managedblockchainquery.model.TokenIdentifier.ReadOnly
    ] = ZIO.succeed(tokenIdentifier)
    def getOwnerIdentifier: ZIO[
      Any,
      Nothing,
      zio.aws.managedblockchainquery.model.OwnerIdentifier.ReadOnly
    ] = ZIO.succeed(ownerIdentifier)
    def getAtBlockchainInstant: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchainquery.model.BlockchainInstant.ReadOnly
    ] = AwsError.unwrapOptionField("atBlockchainInstant", atBlockchainInstant)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.BatchGetTokenBalanceInputItem
  ) extends zio.aws.managedblockchainquery.model.BatchGetTokenBalanceInputItem.ReadOnly {
    override val tokenIdentifier
        : zio.aws.managedblockchainquery.model.TokenIdentifier.ReadOnly =
      zio.aws.managedblockchainquery.model.TokenIdentifier
        .wrap(impl.tokenIdentifier())
    override val ownerIdentifier
        : zio.aws.managedblockchainquery.model.OwnerIdentifier.ReadOnly =
      zio.aws.managedblockchainquery.model.OwnerIdentifier
        .wrap(impl.ownerIdentifier())
    override val atBlockchainInstant: Optional[
      zio.aws.managedblockchainquery.model.BlockchainInstant.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.atBlockchainInstant())
      .map(value =>
        zio.aws.managedblockchainquery.model.BlockchainInstant.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.BatchGetTokenBalanceInputItem
  ): zio.aws.managedblockchainquery.model.BatchGetTokenBalanceInputItem.ReadOnly =
    new Wrapper(impl)
}
