package zio.aws.managedblockchainquery.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.managedblockchainquery.model.primitives.{
  Timestamp,
  QueryTransactionHash
}
import scala.jdk.CollectionConverters._
final case class TransactionOutputItem(
    transactionHash: QueryTransactionHash,
    network: zio.aws.managedblockchainquery.model.QueryNetwork,
    transactionTimestamp: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchainquery.model.TransactionOutputItem = {
    import TransactionOutputItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchainquery.model.TransactionOutputItem
      .builder()
      .transactionHash(
        QueryTransactionHash.unwrap(transactionHash): java.lang.String
      )
      .network(network.unwrap)
      .transactionTimestamp(Timestamp.unwrap(transactionTimestamp): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchainquery.model.TransactionOutputItem.ReadOnly =
    zio.aws.managedblockchainquery.model.TransactionOutputItem
      .wrap(buildAwsValue())
}
object TransactionOutputItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchainquery.model.TransactionOutputItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchainquery.model.TransactionOutputItem =
      zio.aws.managedblockchainquery.model
        .TransactionOutputItem(transactionHash, network, transactionTimestamp)
    def transactionHash: QueryTransactionHash
    def network: zio.aws.managedblockchainquery.model.QueryNetwork
    def transactionTimestamp: Timestamp
    def getTransactionHash: ZIO[Any, Nothing, QueryTransactionHash] =
      ZIO.succeed(transactionHash)
    def getNetwork
        : ZIO[Any, Nothing, zio.aws.managedblockchainquery.model.QueryNetwork] =
      ZIO.succeed(network)
    def getTransactionTimestamp: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(transactionTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.TransactionOutputItem
  ) extends zio.aws.managedblockchainquery.model.TransactionOutputItem.ReadOnly {
    override val transactionHash: QueryTransactionHash =
      zio.aws.managedblockchainquery.model.primitives
        .QueryTransactionHash(impl.transactionHash())
    override val network: zio.aws.managedblockchainquery.model.QueryNetwork =
      zio.aws.managedblockchainquery.model.QueryNetwork.wrap(impl.network())
    override val transactionTimestamp: Timestamp =
      zio.aws.managedblockchainquery.model.primitives
        .Timestamp(impl.transactionTimestamp())
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.TransactionOutputItem
  ): zio.aws.managedblockchainquery.model.TransactionOutputItem.ReadOnly =
    new Wrapper(impl)
}
