package zio.aws.managedblockchainquery
import zio.aws.managedblockchainquery.model.TransactionEvent.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.managedblockchainquery.model.{
  GetAssetContractRequest,
  ListTransactionsRequest,
  GetTransactionRequest,
  ListTokenBalancesRequest,
  GetTokenBalanceRequest,
  ListTransactionEventsRequest,
  BatchGetTokenBalanceRequest,
  ListAssetContractsRequest
}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.managedblockchainquery.ManagedBlockchainQueryAsyncClient
import zio.stream.ZStream
object ManagedBlockchainQueryMock extends Mock[ManagedBlockchainQuery] {
  object ListTransactions
      extends Stream[
        ListTransactionsRequest,
        AwsError,
        zio.aws.managedblockchainquery.model.TransactionOutputItem.ReadOnly
      ]
  object ListTransactionsPaginated
      extends Effect[
        ListTransactionsRequest,
        AwsError,
        zio.aws.managedblockchainquery.model.ListTransactionsResponse.ReadOnly
      ]
  object ListTokenBalances
      extends Stream[
        ListTokenBalancesRequest,
        AwsError,
        zio.aws.managedblockchainquery.model.TokenBalance.ReadOnly
      ]
  object ListTokenBalancesPaginated
      extends Effect[
        ListTokenBalancesRequest,
        AwsError,
        zio.aws.managedblockchainquery.model.ListTokenBalancesResponse.ReadOnly
      ]
  object ListTransactionEvents
      extends Stream[ListTransactionEventsRequest, AwsError, ReadOnly]
  object ListTransactionEventsPaginated
      extends Effect[
        ListTransactionEventsRequest,
        AwsError,
        zio.aws.managedblockchainquery.model.ListTransactionEventsResponse.ReadOnly
      ]
  object ListAssetContracts
      extends Stream[
        ListAssetContractsRequest,
        AwsError,
        zio.aws.managedblockchainquery.model.AssetContract.ReadOnly
      ]
  object ListAssetContractsPaginated
      extends Effect[
        ListAssetContractsRequest,
        AwsError,
        zio.aws.managedblockchainquery.model.ListAssetContractsResponse.ReadOnly
      ]
  object GetAssetContract
      extends Effect[
        GetAssetContractRequest,
        AwsError,
        zio.aws.managedblockchainquery.model.GetAssetContractResponse.ReadOnly
      ]
  object GetTransaction
      extends Effect[
        GetTransactionRequest,
        AwsError,
        zio.aws.managedblockchainquery.model.GetTransactionResponse.ReadOnly
      ]
  object BatchGetTokenBalance
      extends Effect[
        BatchGetTokenBalanceRequest,
        AwsError,
        zio.aws.managedblockchainquery.model.BatchGetTokenBalanceResponse.ReadOnly
      ]
  object GetTokenBalance
      extends Effect[
        GetTokenBalanceRequest,
        AwsError,
        zio.aws.managedblockchainquery.model.GetTokenBalanceResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, ManagedBlockchainQuery] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, ManagedBlockchainQuery] { rts =>
        zio.ZIO.succeed {
          new ManagedBlockchainQuery {
            val api: ManagedBlockchainQueryAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): ManagedBlockchainQuery = this
            def listTransactions(request: ListTransactionsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.managedblockchainquery.model.TransactionOutputItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListTransactions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listTransactionsPaginated(request: ListTransactionsRequest): IO[
              AwsError,
              zio.aws.managedblockchainquery.model.ListTransactionsResponse.ReadOnly
            ] = proxy(ListTransactionsPaginated, request)
            def listTokenBalances(request: ListTokenBalancesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.managedblockchainquery.model.TokenBalance.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListTokenBalances, request)
                }
                .getOrThrowFiberFailure()
            }
            def listTokenBalancesPaginated(
                request: ListTokenBalancesRequest
            ): IO[
              AwsError,
              zio.aws.managedblockchainquery.model.ListTokenBalancesResponse.ReadOnly
            ] = proxy(ListTokenBalancesPaginated, request)
            def listTransactionEvents(
                request: ListTransactionEventsRequest
            ): ZStream[Any, AwsError, ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListTransactionEvents, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listTransactionEventsPaginated(
                request: ListTransactionEventsRequest
            ): IO[
              AwsError,
              zio.aws.managedblockchainquery.model.ListTransactionEventsResponse.ReadOnly
            ] = proxy(ListTransactionEventsPaginated, request)
            def listAssetContracts(request: ListAssetContractsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.managedblockchainquery.model.AssetContract.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListAssetContracts, request)
                }
                .getOrThrowFiberFailure()
            }
            def listAssetContractsPaginated(
                request: ListAssetContractsRequest
            ): IO[
              AwsError,
              zio.aws.managedblockchainquery.model.ListAssetContractsResponse.ReadOnly
            ] = proxy(ListAssetContractsPaginated, request)
            def getAssetContract(request: GetAssetContractRequest): IO[
              AwsError,
              zio.aws.managedblockchainquery.model.GetAssetContractResponse.ReadOnly
            ] = proxy(GetAssetContract, request)
            def getTransaction(request: GetTransactionRequest): IO[
              AwsError,
              zio.aws.managedblockchainquery.model.GetTransactionResponse.ReadOnly
            ] = proxy(GetTransaction, request)
            def batchGetTokenBalance(request: BatchGetTokenBalanceRequest): IO[
              AwsError,
              zio.aws.managedblockchainquery.model.BatchGetTokenBalanceResponse.ReadOnly
            ] = proxy(BatchGetTokenBalance, request)
            def getTokenBalance(request: GetTokenBalanceRequest): IO[
              AwsError,
              zio.aws.managedblockchainquery.model.GetTokenBalanceResponse.ReadOnly
            ] = proxy(GetTokenBalance, request)
          }
        }
      }
    }
  }
}
