package zio.aws.managedblockchainquery.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.managedblockchainquery.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class ContractMetadata(
    name: Optional[String] = Optional.Absent,
    symbol: Optional[String] = Optional.Absent,
    decimals: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchainquery.model.ContractMetadata = {
    import ContractMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchainquery.model.ContractMetadata
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(symbol.map(value => value: java.lang.String))(_.symbol)
      .optionallyWith(decimals.map(value => value: java.lang.Integer))(
        _.decimals
      )
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchainquery.model.ContractMetadata.ReadOnly =
    zio.aws.managedblockchainquery.model.ContractMetadata.wrap(buildAwsValue())
}
object ContractMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchainquery.model.ContractMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchainquery.model.ContractMetadata =
      zio.aws.managedblockchainquery.model.ContractMetadata(
        name.map(value => value),
        symbol.map(value => value),
        decimals.map(value => value)
      )
    def name: Optional[String]
    def symbol: Optional[String]
    def decimals: Optional[Integer]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getSymbol: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("symbol", symbol)
    def getDecimals: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("decimals", decimals)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.ContractMetadata
  ) extends zio.aws.managedblockchainquery.model.ContractMetadata.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val symbol: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.symbol())
      .map(value => value: String)
    override val decimals: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.decimals())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.ContractMetadata
  ): zio.aws.managedblockchainquery.model.ContractMetadata.ReadOnly =
    new Wrapper(impl)
}
