package zio.aws.managedblockchainquery
import zio.aws.managedblockchainquery.model.TransactionEvent.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.managedblockchainquery.model.{
  GetAssetContractRequest,
  ListTransactionsRequest,
  GetTransactionRequest,
  ListTokenBalancesRequest,
  GetTokenBalanceRequest,
  ListTransactionEventsRequest,
  BatchGetTokenBalanceRequest,
  ListAssetContractsRequest
}
import software.amazon.awssdk.services.managedblockchainquery.model.{
  ListTransactionsResponse,
  GetTokenBalanceResponse,
  AssetContract,
  ListAssetContractsResponse,
  ListTransactionEventsResponse,
  GetAssetContractResponse,
  BatchGetTokenBalanceResponse,
  TransactionEvent,
  GetTransactionResponse,
  TokenBalance,
  ListTokenBalancesResponse,
  TransactionOutputItem
}
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.managedblockchainquery.paginators.{
  ListAssetContractsPublisher,
  ListTransactionEventsPublisher,
  ListTokenBalancesPublisher,
  ListTransactionsPublisher
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.managedblockchainquery.{
  ManagedBlockchainQueryAsyncClientBuilder,
  ManagedBlockchainQueryAsyncClient
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait ManagedBlockchainQuery extends AspectSupport[ManagedBlockchainQuery] {
  val api: ManagedBlockchainQueryAsyncClient
  def listTransactions(request: ListTransactionsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.managedblockchainquery.model.TransactionOutputItem.ReadOnly
  ]
  def listTransactionsPaginated(request: ListTransactionsRequest): IO[
    AwsError,
    zio.aws.managedblockchainquery.model.ListTransactionsResponse.ReadOnly
  ]
  def listTokenBalances(request: ListTokenBalancesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.managedblockchainquery.model.TokenBalance.ReadOnly
  ]
  def listTokenBalancesPaginated(request: ListTokenBalancesRequest): IO[
    AwsError,
    zio.aws.managedblockchainquery.model.ListTokenBalancesResponse.ReadOnly
  ]
  def listTransactionEvents(
      request: ListTransactionEventsRequest
  ): ZStream[Any, AwsError, ReadOnly]
  def listTransactionEventsPaginated(request: ListTransactionEventsRequest): IO[
    AwsError,
    zio.aws.managedblockchainquery.model.ListTransactionEventsResponse.ReadOnly
  ]
  def listAssetContracts(request: ListAssetContractsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.managedblockchainquery.model.AssetContract.ReadOnly
  ]
  def listAssetContractsPaginated(request: ListAssetContractsRequest): IO[
    AwsError,
    zio.aws.managedblockchainquery.model.ListAssetContractsResponse.ReadOnly
  ]
  def getAssetContract(request: GetAssetContractRequest): IO[
    AwsError,
    zio.aws.managedblockchainquery.model.GetAssetContractResponse.ReadOnly
  ]
  def getTransaction(request: GetTransactionRequest): IO[
    AwsError,
    zio.aws.managedblockchainquery.model.GetTransactionResponse.ReadOnly
  ]
  def batchGetTokenBalance(request: BatchGetTokenBalanceRequest): IO[
    AwsError,
    zio.aws.managedblockchainquery.model.BatchGetTokenBalanceResponse.ReadOnly
  ]
  def getTokenBalance(request: GetTokenBalanceRequest): IO[
    AwsError,
    zio.aws.managedblockchainquery.model.GetTokenBalanceResponse.ReadOnly
  ]
}
object ManagedBlockchainQuery {
  val live: ZLayer[AwsConfig, java.lang.Throwable, ManagedBlockchainQuery] =
    customized(identity)
  def customized(
      customization: ManagedBlockchainQueryAsyncClientBuilder => ManagedBlockchainQueryAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, ManagedBlockchainQuery] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: ManagedBlockchainQueryAsyncClientBuilder => ManagedBlockchainQueryAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, ManagedBlockchainQuery] =
    for (
      awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
      builder = ManagedBlockchainQueryAsyncClient
        .builder()
        .asyncConfiguration(
          software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
            .builder()
            .advancedOption(
              software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
              executor.asJava
            )
            .build()
        );
      b0 <- awsConfig.configure[
        ManagedBlockchainQueryAsyncClient,
        ManagedBlockchainQueryAsyncClientBuilder
      ](builder);
      b1 <- awsConfig.configureHttpClient[
        ManagedBlockchainQueryAsyncClient,
        ManagedBlockchainQueryAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
    )
      yield new ManagedBlockchainQueryImpl(
        client,
        AwsCallAspect.identity,
        ZEnvironment.empty
      )
  private class ManagedBlockchainQueryImpl[R](
      override val api: ManagedBlockchainQueryAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends ManagedBlockchainQuery
      with AwsServiceBase[R] {
    override val serviceName: String = "ManagedBlockchainQuery"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): ManagedBlockchainQueryImpl[R1] =
      new ManagedBlockchainQueryImpl(api, newAspect, r)
    def listTransactions(request: ListTransactionsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.managedblockchainquery.model.TransactionOutputItem.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionsRequest,
      TransactionOutputItem,
      ListTransactionsPublisher
    ]("listTransactions", api.listTransactionsPaginator, _.transactions())(
      request.buildAwsValue()
    ).map(item =>
      zio.aws.managedblockchainquery.model.TransactionOutputItem.wrap(item)
    ).provideEnvironment(r)
    def listTransactionsPaginated(request: ListTransactionsRequest): IO[
      AwsError,
      zio.aws.managedblockchainquery.model.ListTransactionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionsRequest,
      ListTransactionsResponse
    ]("listTransactions", api.listTransactions)(request.buildAwsValue())
      .map(zio.aws.managedblockchainquery.model.ListTransactionsResponse.wrap)
      .provideEnvironment(r)
    def listTokenBalances(request: ListTokenBalancesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.managedblockchainquery.model.TokenBalance.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.managedblockchainquery.model.ListTokenBalancesRequest,
      TokenBalance,
      ListTokenBalancesPublisher
    ]("listTokenBalances", api.listTokenBalancesPaginator, _.tokenBalances())(
      request.buildAwsValue()
    ).map(item => zio.aws.managedblockchainquery.model.TokenBalance.wrap(item))
      .provideEnvironment(r)
    def listTokenBalancesPaginated(request: ListTokenBalancesRequest): IO[
      AwsError,
      zio.aws.managedblockchainquery.model.ListTokenBalancesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.managedblockchainquery.model.ListTokenBalancesRequest,
      ListTokenBalancesResponse
    ]("listTokenBalances", api.listTokenBalances)(request.buildAwsValue())
      .map(zio.aws.managedblockchainquery.model.ListTokenBalancesResponse.wrap)
      .provideEnvironment(r)
    def listTransactionEvents(
        request: ListTransactionEventsRequest
    ): ZStream[Any, AwsError, ReadOnly] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionEventsRequest,
      TransactionEvent,
      ListTransactionEventsPublisher
    ]("listTransactionEvents", api.listTransactionEventsPaginator, _.events())(
      request.buildAwsValue()
    ).map(item =>
      zio.aws.managedblockchainquery.model.TransactionEvent.wrap(item)
    ).provideEnvironment(r)
    def listTransactionEventsPaginated(
        request: ListTransactionEventsRequest
    ): IO[
      AwsError,
      zio.aws.managedblockchainquery.model.ListTransactionEventsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionEventsRequest,
      ListTransactionEventsResponse
    ]("listTransactionEvents", api.listTransactionEvents)(
      request.buildAwsValue()
    ).map(
      zio.aws.managedblockchainquery.model.ListTransactionEventsResponse.wrap
    ).provideEnvironment(r)
    def listAssetContracts(request: ListAssetContractsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.managedblockchainquery.model.AssetContract.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.managedblockchainquery.model.ListAssetContractsRequest,
      AssetContract,
      ListAssetContractsPublisher
    ]("listAssetContracts", api.listAssetContractsPaginator, _.contracts())(
      request.buildAwsValue()
    ).map(item => zio.aws.managedblockchainquery.model.AssetContract.wrap(item))
      .provideEnvironment(r)
    def listAssetContractsPaginated(request: ListAssetContractsRequest): IO[
      AwsError,
      zio.aws.managedblockchainquery.model.ListAssetContractsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.managedblockchainquery.model.ListAssetContractsRequest,
      ListAssetContractsResponse
    ]("listAssetContracts", api.listAssetContracts)(request.buildAwsValue())
      .map(zio.aws.managedblockchainquery.model.ListAssetContractsResponse.wrap)
      .provideEnvironment(r)
    def getAssetContract(request: GetAssetContractRequest): IO[
      AwsError,
      zio.aws.managedblockchainquery.model.GetAssetContractResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.managedblockchainquery.model.GetAssetContractRequest,
      GetAssetContractResponse
    ]("getAssetContract", api.getAssetContract)(request.buildAwsValue())
      .map(zio.aws.managedblockchainquery.model.GetAssetContractResponse.wrap)
      .provideEnvironment(r)
    def getTransaction(request: GetTransactionRequest): IO[
      AwsError,
      zio.aws.managedblockchainquery.model.GetTransactionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.managedblockchainquery.model.GetTransactionRequest,
      GetTransactionResponse
    ]("getTransaction", api.getTransaction)(request.buildAwsValue())
      .map(zio.aws.managedblockchainquery.model.GetTransactionResponse.wrap)
      .provideEnvironment(r)
    def batchGetTokenBalance(request: BatchGetTokenBalanceRequest): IO[
      AwsError,
      zio.aws.managedblockchainquery.model.BatchGetTokenBalanceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.managedblockchainquery.model.BatchGetTokenBalanceRequest,
      BatchGetTokenBalanceResponse
    ]("batchGetTokenBalance", api.batchGetTokenBalance)(request.buildAwsValue())
      .map(
        zio.aws.managedblockchainquery.model.BatchGetTokenBalanceResponse.wrap
      )
      .provideEnvironment(r)
    def getTokenBalance(request: GetTokenBalanceRequest): IO[
      AwsError,
      zio.aws.managedblockchainquery.model.GetTokenBalanceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.managedblockchainquery.model.GetTokenBalanceRequest,
      GetTokenBalanceResponse
    ]("getTokenBalance", api.getTokenBalance)(request.buildAwsValue())
      .map(zio.aws.managedblockchainquery.model.GetTokenBalanceResponse.wrap)
      .provideEnvironment(r)
  }
  def listTransactions(request: ListTransactionsRequest): ZStream[
    zio.aws.managedblockchainquery.ManagedBlockchainQuery,
    AwsError,
    zio.aws.managedblockchainquery.model.TransactionOutputItem.ReadOnly
  ] = ZStream.serviceWithStream(_.listTransactions(request))
  def listTransactionsPaginated(request: ListTransactionsRequest): ZIO[
    zio.aws.managedblockchainquery.ManagedBlockchainQuery,
    AwsError,
    zio.aws.managedblockchainquery.model.ListTransactionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTransactionsPaginated(request))
  def listTokenBalances(request: ListTokenBalancesRequest): ZStream[
    zio.aws.managedblockchainquery.ManagedBlockchainQuery,
    AwsError,
    zio.aws.managedblockchainquery.model.TokenBalance.ReadOnly
  ] = ZStream.serviceWithStream(_.listTokenBalances(request))
  def listTokenBalancesPaginated(request: ListTokenBalancesRequest): ZIO[
    zio.aws.managedblockchainquery.ManagedBlockchainQuery,
    AwsError,
    zio.aws.managedblockchainquery.model.ListTokenBalancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTokenBalancesPaginated(request))
  def listTransactionEvents(request: ListTransactionEventsRequest): ZStream[
    zio.aws.managedblockchainquery.ManagedBlockchainQuery,
    AwsError,
    ReadOnly
  ] = ZStream.serviceWithStream(_.listTransactionEvents(request))
  def listTransactionEventsPaginated(
      request: ListTransactionEventsRequest
  ): ZIO[
    zio.aws.managedblockchainquery.ManagedBlockchainQuery,
    AwsError,
    zio.aws.managedblockchainquery.model.ListTransactionEventsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTransactionEventsPaginated(request))
  def listAssetContracts(request: ListAssetContractsRequest): ZStream[
    zio.aws.managedblockchainquery.ManagedBlockchainQuery,
    AwsError,
    zio.aws.managedblockchainquery.model.AssetContract.ReadOnly
  ] = ZStream.serviceWithStream(_.listAssetContracts(request))
  def listAssetContractsPaginated(request: ListAssetContractsRequest): ZIO[
    zio.aws.managedblockchainquery.ManagedBlockchainQuery,
    AwsError,
    zio.aws.managedblockchainquery.model.ListAssetContractsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAssetContractsPaginated(request))
  def getAssetContract(request: GetAssetContractRequest): ZIO[
    zio.aws.managedblockchainquery.ManagedBlockchainQuery,
    AwsError,
    zio.aws.managedblockchainquery.model.GetAssetContractResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAssetContract(request))
  def getTransaction(request: GetTransactionRequest): ZIO[
    zio.aws.managedblockchainquery.ManagedBlockchainQuery,
    AwsError,
    zio.aws.managedblockchainquery.model.GetTransactionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTransaction(request))
  def batchGetTokenBalance(request: BatchGetTokenBalanceRequest): ZIO[
    zio.aws.managedblockchainquery.ManagedBlockchainQuery,
    AwsError,
    zio.aws.managedblockchainquery.model.BatchGetTokenBalanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetTokenBalance(request))
  def getTokenBalance(request: GetTokenBalanceRequest): ZIO[
    zio.aws.managedblockchainquery.ManagedBlockchainQuery,
    AwsError,
    zio.aws.managedblockchainquery.model.GetTokenBalanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTokenBalance(request))
}
