package zio.aws.managedblockchainquery.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.managedblockchainquery.model.primitives.{
  QueryTokenId,
  ChainAddress
}
import scala.jdk.CollectionConverters._
final case class TokenIdentifier(
    network: zio.aws.managedblockchainquery.model.QueryNetwork,
    contractAddress: Optional[ChainAddress] = Optional.Absent,
    tokenId: Optional[QueryTokenId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchainquery.model.TokenIdentifier = {
    import TokenIdentifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchainquery.model.TokenIdentifier
      .builder()
      .network(network.unwrap)
      .optionallyWith(
        contractAddress.map(value =>
          ChainAddress.unwrap(value): java.lang.String
        )
      )(_.contractAddress)
      .optionallyWith(
        tokenId.map(value => QueryTokenId.unwrap(value): java.lang.String)
      )(_.tokenId)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchainquery.model.TokenIdentifier.ReadOnly =
    zio.aws.managedblockchainquery.model.TokenIdentifier.wrap(buildAwsValue())
}
object TokenIdentifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchainquery.model.TokenIdentifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchainquery.model.TokenIdentifier =
      zio.aws.managedblockchainquery.model.TokenIdentifier(
        network,
        contractAddress.map(value => value),
        tokenId.map(value => value)
      )
    def network: zio.aws.managedblockchainquery.model.QueryNetwork
    def contractAddress: Optional[ChainAddress]
    def tokenId: Optional[QueryTokenId]
    def getNetwork
        : ZIO[Any, Nothing, zio.aws.managedblockchainquery.model.QueryNetwork] =
      ZIO.succeed(network)
    def getContractAddress: ZIO[Any, AwsError, ChainAddress] =
      AwsError.unwrapOptionField("contractAddress", contractAddress)
    def getTokenId: ZIO[Any, AwsError, QueryTokenId] =
      AwsError.unwrapOptionField("tokenId", tokenId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.TokenIdentifier
  ) extends zio.aws.managedblockchainquery.model.TokenIdentifier.ReadOnly {
    override val network: zio.aws.managedblockchainquery.model.QueryNetwork =
      zio.aws.managedblockchainquery.model.QueryNetwork.wrap(impl.network())
    override val contractAddress: Optional[ChainAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.contractAddress())
      .map(value =>
        zio.aws.managedblockchainquery.model.primitives.ChainAddress(value)
      )
    override val tokenId: Optional[QueryTokenId] = zio.aws.core.internal
      .optionalFromNullable(impl.tokenId())
      .map(value =>
        zio.aws.managedblockchainquery.model.primitives.QueryTokenId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.TokenIdentifier
  ): zio.aws.managedblockchainquery.model.TokenIdentifier.ReadOnly =
    new Wrapper(impl)
}
