package zio.aws.managedblockchainquery.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetTransactionResponse(
    transaction: zio.aws.managedblockchainquery.model.Transaction
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchainquery.model.GetTransactionResponse = {
    import GetTransactionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchainquery.model.GetTransactionResponse
      .builder()
      .transaction(transaction.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchainquery.model.GetTransactionResponse.ReadOnly =
    zio.aws.managedblockchainquery.model.GetTransactionResponse
      .wrap(buildAwsValue())
}
object GetTransactionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchainquery.model.GetTransactionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.managedblockchainquery.model.GetTransactionResponse =
      zio.aws.managedblockchainquery.model
        .GetTransactionResponse(transaction.asEditable)
    def transaction: zio.aws.managedblockchainquery.model.Transaction.ReadOnly
    def getTransaction: ZIO[
      Any,
      Nothing,
      zio.aws.managedblockchainquery.model.Transaction.ReadOnly
    ] = ZIO.succeed(transaction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.GetTransactionResponse
  ) extends zio.aws.managedblockchainquery.model.GetTransactionResponse.ReadOnly {
    override val transaction
        : zio.aws.managedblockchainquery.model.Transaction.ReadOnly =
      zio.aws.managedblockchainquery.model.Transaction.wrap(impl.transaction())
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.GetTransactionResponse
  ): zio.aws.managedblockchainquery.model.GetTransactionResponse.ReadOnly =
    new Wrapper(impl)
}
