package zio.aws.managedblockchainquery.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetAssetContractRequest(
    contractIdentifier: zio.aws.managedblockchainquery.model.ContractIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchainquery.model.GetAssetContractRequest = {
    import GetAssetContractRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchainquery.model.GetAssetContractRequest
      .builder()
      .contractIdentifier(contractIdentifier.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchainquery.model.GetAssetContractRequest.ReadOnly =
    zio.aws.managedblockchainquery.model.GetAssetContractRequest
      .wrap(buildAwsValue())
}
object GetAssetContractRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchainquery.model.GetAssetContractRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.managedblockchainquery.model.GetAssetContractRequest =
      zio.aws.managedblockchainquery.model
        .GetAssetContractRequest(contractIdentifier.asEditable)
    def contractIdentifier
        : zio.aws.managedblockchainquery.model.ContractIdentifier.ReadOnly
    def getContractIdentifier: ZIO[
      Any,
      Nothing,
      zio.aws.managedblockchainquery.model.ContractIdentifier.ReadOnly
    ] = ZIO.succeed(contractIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.GetAssetContractRequest
  ) extends zio.aws.managedblockchainquery.model.GetAssetContractRequest.ReadOnly {
    override val contractIdentifier
        : zio.aws.managedblockchainquery.model.ContractIdentifier.ReadOnly =
      zio.aws.managedblockchainquery.model.ContractIdentifier
        .wrap(impl.contractIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.GetAssetContractRequest
  ): zio.aws.managedblockchainquery.model.GetAssetContractRequest.ReadOnly =
    new Wrapper(impl)
}
