package zio.aws.managedblockchainquery.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListTransactionsSort(
    sortBy: Optional[
      zio.aws.managedblockchainquery.model.ListTransactionsSortBy
    ] = Optional.Absent,
    sortOrder: Optional[zio.aws.managedblockchainquery.model.SortOrder] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionsSort = {
    import ListTransactionsSort.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionsSort
      .builder()
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchainquery.model.ListTransactionsSort.ReadOnly =
    zio.aws.managedblockchainquery.model.ListTransactionsSort
      .wrap(buildAwsValue())
}
object ListTransactionsSort {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionsSort
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchainquery.model.ListTransactionsSort =
      zio.aws.managedblockchainquery.model.ListTransactionsSort(
        sortBy.map(value => value),
        sortOrder.map(value => value)
      )
    def sortBy
        : Optional[zio.aws.managedblockchainquery.model.ListTransactionsSortBy]
    def sortOrder: Optional[zio.aws.managedblockchainquery.model.SortOrder]
    def getSortBy: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchainquery.model.ListTransactionsSortBy
    ] = AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.managedblockchainquery.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionsSort
  ) extends zio.aws.managedblockchainquery.model.ListTransactionsSort.ReadOnly {
    override val sortBy: Optional[
      zio.aws.managedblockchainquery.model.ListTransactionsSortBy
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sortBy())
      .map(value =>
        zio.aws.managedblockchainquery.model.ListTransactionsSortBy.wrap(value)
      )
    override val sortOrder
        : Optional[zio.aws.managedblockchainquery.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value =>
          zio.aws.managedblockchainquery.model.SortOrder.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionsSort
  ): zio.aws.managedblockchainquery.model.ListTransactionsSort.ReadOnly =
    new Wrapper(impl)
}
