package zio.aws.managedblockchainquery.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchGetTokenBalanceResponse(
    tokenBalances: Iterable[
      zio.aws.managedblockchainquery.model.BatchGetTokenBalanceOutputItem
    ],
    errors: Iterable[
      zio.aws.managedblockchainquery.model.BatchGetTokenBalanceErrorItem
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchainquery.model.BatchGetTokenBalanceResponse = {
    import BatchGetTokenBalanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchainquery.model.BatchGetTokenBalanceResponse
      .builder()
      .tokenBalances(tokenBalances.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .errors(errors.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchainquery.model.BatchGetTokenBalanceResponse.ReadOnly =
    zio.aws.managedblockchainquery.model.BatchGetTokenBalanceResponse
      .wrap(buildAwsValue())
}
object BatchGetTokenBalanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchainquery.model.BatchGetTokenBalanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.managedblockchainquery.model.BatchGetTokenBalanceResponse =
      zio.aws.managedblockchainquery.model.BatchGetTokenBalanceResponse(
        tokenBalances.map { item =>
          item.asEditable
        },
        errors.map { item =>
          item.asEditable
        }
      )
    def tokenBalances: List[
      zio.aws.managedblockchainquery.model.BatchGetTokenBalanceOutputItem.ReadOnly
    ]
    def errors: List[
      zio.aws.managedblockchainquery.model.BatchGetTokenBalanceErrorItem.ReadOnly
    ]
    def getTokenBalances: ZIO[Any, Nothing, List[
      zio.aws.managedblockchainquery.model.BatchGetTokenBalanceOutputItem.ReadOnly
    ]] = ZIO.succeed(tokenBalances)
    def getErrors: ZIO[Any, Nothing, List[
      zio.aws.managedblockchainquery.model.BatchGetTokenBalanceErrorItem.ReadOnly
    ]] = ZIO.succeed(errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.BatchGetTokenBalanceResponse
  ) extends zio.aws.managedblockchainquery.model.BatchGetTokenBalanceResponse.ReadOnly {
    override val tokenBalances: List[
      zio.aws.managedblockchainquery.model.BatchGetTokenBalanceOutputItem.ReadOnly
    ] = impl
      .tokenBalances()
      .asScala
      .map { item =>
        zio.aws.managedblockchainquery.model.BatchGetTokenBalanceOutputItem
          .wrap(item)
      }
      .toList
    override val errors: List[
      zio.aws.managedblockchainquery.model.BatchGetTokenBalanceErrorItem.ReadOnly
    ] = impl
      .errors()
      .asScala
      .map { item =>
        zio.aws.managedblockchainquery.model.BatchGetTokenBalanceErrorItem
          .wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.BatchGetTokenBalanceResponse
  ): zio.aws.managedblockchainquery.model.BatchGetTokenBalanceResponse.ReadOnly =
    new Wrapper(impl)
}
