package zio.aws.managedblockchainquery.model
import scala.jdk.CollectionConverters._
sealed trait SortOrder {
  def unwrap
      : software.amazon.awssdk.services.managedblockchainquery.model.SortOrder
}
object SortOrder {
  def wrap(
      value: software.amazon.awssdk.services.managedblockchainquery.model.SortOrder
  ): zio.aws.managedblockchainquery.model.SortOrder = value match {
    case software.amazon.awssdk.services.managedblockchainquery.model.SortOrder.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.managedblockchainquery.model.SortOrder.ASCENDING =>
      val r = ASCENDING
      r
    case software.amazon.awssdk.services.managedblockchainquery.model.SortOrder.DESCENDING =>
      val r = DESCENDING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.managedblockchainquery.model.SortOrder {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchainquery.model.SortOrder =
      software.amazon.awssdk.services.managedblockchainquery.model.SortOrder.UNKNOWN_TO_SDK_VERSION
  }
  case object ASCENDING extends zio.aws.managedblockchainquery.model.SortOrder {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchainquery.model.SortOrder =
      software.amazon.awssdk.services.managedblockchainquery.model.SortOrder.ASCENDING
  }
  case object DESCENDING
      extends zio.aws.managedblockchainquery.model.SortOrder {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchainquery.model.SortOrder =
      software.amazon.awssdk.services.managedblockchainquery.model.SortOrder.DESCENDING
  }
}
