package zio.aws.managedblockchainquery.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.managedblockchainquery.model.primitives.ChainAddress
import scala.jdk.CollectionConverters._
final case class OwnerIdentifier(address: ChainAddress) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchainquery.model.OwnerIdentifier = {
    import OwnerIdentifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchainquery.model.OwnerIdentifier
      .builder()
      .address(ChainAddress.unwrap(address): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchainquery.model.OwnerIdentifier.ReadOnly =
    zio.aws.managedblockchainquery.model.OwnerIdentifier.wrap(buildAwsValue())
}
object OwnerIdentifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchainquery.model.OwnerIdentifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchainquery.model.OwnerIdentifier =
      zio.aws.managedblockchainquery.model.OwnerIdentifier(address)
    def address: ChainAddress
    def getAddress: ZIO[Any, Nothing, ChainAddress] = ZIO.succeed(address)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.OwnerIdentifier
  ) extends zio.aws.managedblockchainquery.model.OwnerIdentifier.ReadOnly {
    override val address: ChainAddress =
      zio.aws.managedblockchainquery.model.primitives
        .ChainAddress(impl.address())
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.OwnerIdentifier
  ): zio.aws.managedblockchainquery.model.OwnerIdentifier.ReadOnly =
    new Wrapper(impl)
}
