package zio.aws.managedblockchainquery.model
import scala.jdk.CollectionConverters._
sealed trait ErrorType {
  def unwrap
      : software.amazon.awssdk.services.managedblockchainquery.model.ErrorType
}
object ErrorType {
  def wrap(
      value: software.amazon.awssdk.services.managedblockchainquery.model.ErrorType
  ): zio.aws.managedblockchainquery.model.ErrorType = value match {
    case software.amazon.awssdk.services.managedblockchainquery.model.ErrorType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.managedblockchainquery.model.ErrorType.VALIDATION_EXCEPTION =>
      val r = VALIDATION_EXCEPTION
      r
    case software.amazon.awssdk.services.managedblockchainquery.model.ErrorType.RESOURCE_NOT_FOUND_EXCEPTION =>
      val r = RESOURCE_NOT_FOUND_EXCEPTION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.managedblockchainquery.model.ErrorType {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchainquery.model.ErrorType =
      software.amazon.awssdk.services.managedblockchainquery.model.ErrorType.UNKNOWN_TO_SDK_VERSION
  }
  case object VALIDATION_EXCEPTION
      extends zio.aws.managedblockchainquery.model.ErrorType {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchainquery.model.ErrorType =
      software.amazon.awssdk.services.managedblockchainquery.model.ErrorType.VALIDATION_EXCEPTION
  }
  case object RESOURCE_NOT_FOUND_EXCEPTION
      extends zio.aws.managedblockchainquery.model.ErrorType {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchainquery.model.ErrorType =
      software.amazon.awssdk.services.managedblockchainquery.model.ErrorType.RESOURCE_NOT_FOUND_EXCEPTION
  }
}
