package zio.aws.managedblockchainquery.model
import zio.aws.managedblockchainquery.model.primitives.{
  QueryTransactionHash,
  BlockHash,
  Timestamp,
  Integer,
  ChainAddress
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Transaction(
    network: zio.aws.managedblockchainquery.model.QueryNetwork,
    blockHash: Optional[BlockHash] = Optional.Absent,
    transactionHash: QueryTransactionHash,
    blockNumber: Optional[String] = Optional.Absent,
    transactionTimestamp: Timestamp,
    transactionIndex: Long,
    numberOfTransactions: Long,
    status: zio.aws.managedblockchainquery.model.QueryTransactionStatus,
    to: ChainAddress,
    from: Optional[ChainAddress] = Optional.Absent,
    contractAddress: Optional[ChainAddress] = Optional.Absent,
    gasUsed: Optional[String] = Optional.Absent,
    cumulativeGasUsed: Optional[String] = Optional.Absent,
    effectiveGasPrice: Optional[String] = Optional.Absent,
    signatureV: Optional[Integer] = Optional.Absent,
    signatureR: Optional[String] = Optional.Absent,
    signatureS: Optional[String] = Optional.Absent,
    transactionFee: Optional[String] = Optional.Absent,
    transactionId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchainquery.model.Transaction = {
    import Transaction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchainquery.model.Transaction
      .builder()
      .network(network.unwrap)
      .optionallyWith(
        blockHash.map(value => BlockHash.unwrap(value): java.lang.String)
      )(_.blockHash)
      .transactionHash(
        QueryTransactionHash.unwrap(transactionHash): java.lang.String
      )
      .optionallyWith(blockNumber.map(value => value: java.lang.String))(
        _.blockNumber
      )
      .transactionTimestamp(Timestamp.unwrap(transactionTimestamp): Instant)
      .transactionIndex(transactionIndex: java.lang.Long)
      .numberOfTransactions(numberOfTransactions: java.lang.Long)
      .status(status.unwrap)
      .to(ChainAddress.unwrap(to): java.lang.String)
      .optionallyWith(
        from.map(value => ChainAddress.unwrap(value): java.lang.String)
      )(_.from)
      .optionallyWith(
        contractAddress.map(value =>
          ChainAddress.unwrap(value): java.lang.String
        )
      )(_.contractAddress)
      .optionallyWith(gasUsed.map(value => value: java.lang.String))(_.gasUsed)
      .optionallyWith(cumulativeGasUsed.map(value => value: java.lang.String))(
        _.cumulativeGasUsed
      )
      .optionallyWith(effectiveGasPrice.map(value => value: java.lang.String))(
        _.effectiveGasPrice
      )
      .optionallyWith(signatureV.map(value => value: java.lang.Integer))(
        _.signatureV
      )
      .optionallyWith(signatureR.map(value => value: java.lang.String))(
        _.signatureR
      )
      .optionallyWith(signatureS.map(value => value: java.lang.String))(
        _.signatureS
      )
      .optionallyWith(transactionFee.map(value => value: java.lang.String))(
        _.transactionFee
      )
      .optionallyWith(transactionId.map(value => value: java.lang.String))(
        _.transactionId
      )
      .build()
  }
  def asReadOnly: zio.aws.managedblockchainquery.model.Transaction.ReadOnly =
    zio.aws.managedblockchainquery.model.Transaction.wrap(buildAwsValue())
}
object Transaction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchainquery.model.Transaction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchainquery.model.Transaction =
      zio.aws.managedblockchainquery.model.Transaction(
        network,
        blockHash.map(value => value),
        transactionHash,
        blockNumber.map(value => value),
        transactionTimestamp,
        transactionIndex,
        numberOfTransactions,
        status,
        to,
        from.map(value => value),
        contractAddress.map(value => value),
        gasUsed.map(value => value),
        cumulativeGasUsed.map(value => value),
        effectiveGasPrice.map(value => value),
        signatureV.map(value => value),
        signatureR.map(value => value),
        signatureS.map(value => value),
        transactionFee.map(value => value),
        transactionId.map(value => value)
      )
    def network: zio.aws.managedblockchainquery.model.QueryNetwork
    def blockHash: Optional[BlockHash]
    def transactionHash: QueryTransactionHash
    def blockNumber: Optional[String]
    def transactionTimestamp: Timestamp
    def transactionIndex: Long
    def numberOfTransactions: Long
    def status: zio.aws.managedblockchainquery.model.QueryTransactionStatus
    def to: ChainAddress
    def from: Optional[ChainAddress]
    def contractAddress: Optional[ChainAddress]
    def gasUsed: Optional[String]
    def cumulativeGasUsed: Optional[String]
    def effectiveGasPrice: Optional[String]
    def signatureV: Optional[Integer]
    def signatureR: Optional[String]
    def signatureS: Optional[String]
    def transactionFee: Optional[String]
    def transactionId: Optional[String]
    def getNetwork
        : ZIO[Any, Nothing, zio.aws.managedblockchainquery.model.QueryNetwork] =
      ZIO.succeed(network)
    def getBlockHash: ZIO[Any, AwsError, BlockHash] =
      AwsError.unwrapOptionField("blockHash", blockHash)
    def getTransactionHash: ZIO[Any, Nothing, QueryTransactionHash] =
      ZIO.succeed(transactionHash)
    def getBlockNumber: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("blockNumber", blockNumber)
    def getTransactionTimestamp: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(transactionTimestamp)
    def getTransactionIndex: ZIO[Any, Nothing, Long] =
      ZIO.succeed(transactionIndex)
    def getNumberOfTransactions: ZIO[Any, Nothing, Long] =
      ZIO.succeed(numberOfTransactions)
    def getStatus: ZIO[
      Any,
      Nothing,
      zio.aws.managedblockchainquery.model.QueryTransactionStatus
    ] = ZIO.succeed(status)
    def getTo: ZIO[Any, Nothing, ChainAddress] = ZIO.succeed(to)
    def getFrom: ZIO[Any, AwsError, ChainAddress] =
      AwsError.unwrapOptionField("from", from)
    def getContractAddress: ZIO[Any, AwsError, ChainAddress] =
      AwsError.unwrapOptionField("contractAddress", contractAddress)
    def getGasUsed: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("gasUsed", gasUsed)
    def getCumulativeGasUsed: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cumulativeGasUsed", cumulativeGasUsed)
    def getEffectiveGasPrice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("effectiveGasPrice", effectiveGasPrice)
    def getSignatureV: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("signatureV", signatureV)
    def getSignatureR: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("signatureR", signatureR)
    def getSignatureS: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("signatureS", signatureS)
    def getTransactionFee: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("transactionFee", transactionFee)
    def getTransactionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("transactionId", transactionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.Transaction
  ) extends zio.aws.managedblockchainquery.model.Transaction.ReadOnly {
    override val network: zio.aws.managedblockchainquery.model.QueryNetwork =
      zio.aws.managedblockchainquery.model.QueryNetwork.wrap(impl.network())
    override val blockHash: Optional[BlockHash] = zio.aws.core.internal
      .optionalFromNullable(impl.blockHash())
      .map(value =>
        zio.aws.managedblockchainquery.model.primitives.BlockHash(value)
      )
    override val transactionHash: QueryTransactionHash =
      zio.aws.managedblockchainquery.model.primitives
        .QueryTransactionHash(impl.transactionHash())
    override val blockNumber: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.blockNumber())
      .map(value => value: String)
    override val transactionTimestamp: Timestamp =
      zio.aws.managedblockchainquery.model.primitives
        .Timestamp(impl.transactionTimestamp())
    override val transactionIndex: Long = impl.transactionIndex(): Long
    override val numberOfTransactions: Long = impl.numberOfTransactions(): Long
    override val status
        : zio.aws.managedblockchainquery.model.QueryTransactionStatus =
      zio.aws.managedblockchainquery.model.QueryTransactionStatus
        .wrap(impl.status())
    override val to: ChainAddress =
      zio.aws.managedblockchainquery.model.primitives.ChainAddress(impl.to())
    override val from: Optional[ChainAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.from())
      .map(value =>
        zio.aws.managedblockchainquery.model.primitives.ChainAddress(value)
      )
    override val contractAddress: Optional[ChainAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.contractAddress())
      .map(value =>
        zio.aws.managedblockchainquery.model.primitives.ChainAddress(value)
      )
    override val gasUsed: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.gasUsed())
      .map(value => value: String)
    override val cumulativeGasUsed: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cumulativeGasUsed())
      .map(value => value: String)
    override val effectiveGasPrice: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.effectiveGasPrice())
      .map(value => value: String)
    override val signatureV: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.signatureV())
      .map(value => value: Integer)
    override val signatureR: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.signatureR())
      .map(value => value: String)
    override val signatureS: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.signatureS())
      .map(value => value: String)
    override val transactionFee: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.transactionFee())
      .map(value => value: String)
    override val transactionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.transactionId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.Transaction
  ): zio.aws.managedblockchainquery.model.Transaction.ReadOnly = new Wrapper(
    impl
  )
}
