package zio.aws.managedblockchainquery.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.managedblockchainquery.model.primitives.ChainAddress
import scala.jdk.CollectionConverters._
final case class OwnerFilter(address: ChainAddress) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchainquery.model.OwnerFilter = {
    import OwnerFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchainquery.model.OwnerFilter
      .builder()
      .address(ChainAddress.unwrap(address): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchainquery.model.OwnerFilter.ReadOnly =
    zio.aws.managedblockchainquery.model.OwnerFilter.wrap(buildAwsValue())
}
object OwnerFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchainquery.model.OwnerFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchainquery.model.OwnerFilter =
      zio.aws.managedblockchainquery.model.OwnerFilter(address)
    def address: ChainAddress
    def getAddress: ZIO[Any, Nothing, ChainAddress] = ZIO.succeed(address)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.OwnerFilter
  ) extends zio.aws.managedblockchainquery.model.OwnerFilter.ReadOnly {
    override val address: ChainAddress =
      zio.aws.managedblockchainquery.model.primitives
        .ChainAddress(impl.address())
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.OwnerFilter
  ): zio.aws.managedblockchainquery.model.OwnerFilter.ReadOnly = new Wrapper(
    impl
  )
}
