package zio.aws.managedblockchainquery.model
import zio.aws.managedblockchainquery.model.primitives.{
  ListTransactionEventsInputMaxResultsInteger,
  NextToken,
  QueryTransactionHash
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListTransactionEventsRequest(
    transactionHash: QueryTransactionHash,
    network: zio.aws.managedblockchainquery.model.QueryNetwork,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[ListTransactionEventsInputMaxResultsInteger] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionEventsRequest = {
    import ListTransactionEventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionEventsRequest
      .builder()
      .transactionHash(
        QueryTransactionHash.unwrap(transactionHash): java.lang.String
      )
      .network(network.unwrap)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          ListTransactionEventsInputMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchainquery.model.ListTransactionEventsRequest.ReadOnly =
    zio.aws.managedblockchainquery.model.ListTransactionEventsRequest
      .wrap(buildAwsValue())
}
object ListTransactionEventsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionEventsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.managedblockchainquery.model.ListTransactionEventsRequest =
      zio.aws.managedblockchainquery.model.ListTransactionEventsRequest(
        transactionHash,
        network,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def transactionHash: QueryTransactionHash
    def network: zio.aws.managedblockchainquery.model.QueryNetwork
    def nextToken: Optional[NextToken]
    def maxResults: Optional[ListTransactionEventsInputMaxResultsInteger]
    def getTransactionHash: ZIO[Any, Nothing, QueryTransactionHash] =
      ZIO.succeed(transactionHash)
    def getNetwork
        : ZIO[Any, Nothing, zio.aws.managedblockchainquery.model.QueryNetwork] =
      ZIO.succeed(network)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults
        : ZIO[Any, AwsError, ListTransactionEventsInputMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionEventsRequest
  ) extends zio.aws.managedblockchainquery.model.ListTransactionEventsRequest.ReadOnly {
    override val transactionHash: QueryTransactionHash =
      zio.aws.managedblockchainquery.model.primitives
        .QueryTransactionHash(impl.transactionHash())
    override val network: zio.aws.managedblockchainquery.model.QueryNetwork =
      zio.aws.managedblockchainquery.model.QueryNetwork.wrap(impl.network())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.managedblockchainquery.model.primitives.NextToken(value)
      )
    override val maxResults
        : Optional[ListTransactionEventsInputMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.managedblockchainquery.model.primitives
            .ListTransactionEventsInputMaxResultsInteger(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionEventsRequest
  ): zio.aws.managedblockchainquery.model.ListTransactionEventsRequest.ReadOnly =
    new Wrapper(impl)
}
