package zio.aws.managedblockchainquery.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.managedblockchainquery.model.primitives.ChainAddress
import scala.jdk.CollectionConverters._
final case class AssetContract(
    contractIdentifier: zio.aws.managedblockchainquery.model.ContractIdentifier,
    tokenStandard: zio.aws.managedblockchainquery.model.QueryTokenStandard,
    deployerAddress: ChainAddress
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchainquery.model.AssetContract = {
    import AssetContract.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchainquery.model.AssetContract
      .builder()
      .contractIdentifier(contractIdentifier.buildAwsValue())
      .tokenStandard(tokenStandard.unwrap)
      .deployerAddress(ChainAddress.unwrap(deployerAddress): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchainquery.model.AssetContract.ReadOnly =
    zio.aws.managedblockchainquery.model.AssetContract.wrap(buildAwsValue())
}
object AssetContract {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchainquery.model.AssetContract
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchainquery.model.AssetContract =
      zio.aws.managedblockchainquery.model.AssetContract(
        contractIdentifier.asEditable,
        tokenStandard,
        deployerAddress
      )
    def contractIdentifier
        : zio.aws.managedblockchainquery.model.ContractIdentifier.ReadOnly
    def tokenStandard: zio.aws.managedblockchainquery.model.QueryTokenStandard
    def deployerAddress: ChainAddress
    def getContractIdentifier: ZIO[
      Any,
      Nothing,
      zio.aws.managedblockchainquery.model.ContractIdentifier.ReadOnly
    ] = ZIO.succeed(contractIdentifier)
    def getTokenStandard: ZIO[
      Any,
      Nothing,
      zio.aws.managedblockchainquery.model.QueryTokenStandard
    ] = ZIO.succeed(tokenStandard)
    def getDeployerAddress: ZIO[Any, Nothing, ChainAddress] =
      ZIO.succeed(deployerAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.AssetContract
  ) extends zio.aws.managedblockchainquery.model.AssetContract.ReadOnly {
    override val contractIdentifier
        : zio.aws.managedblockchainquery.model.ContractIdentifier.ReadOnly =
      zio.aws.managedblockchainquery.model.ContractIdentifier
        .wrap(impl.contractIdentifier())
    override val tokenStandard
        : zio.aws.managedblockchainquery.model.QueryTokenStandard =
      zio.aws.managedblockchainquery.model.QueryTokenStandard
        .wrap(impl.tokenStandard())
    override val deployerAddress: ChainAddress =
      zio.aws.managedblockchainquery.model.primitives
        .ChainAddress(impl.deployerAddress())
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchainquery.model.AssetContract
  ): zio.aws.managedblockchainquery.model.AssetContract.ReadOnly = new Wrapper(
    impl
  )
}
