package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.ResourceIdString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class VoteOnProposalRequest(
    networkId: ResourceIdString,
    proposalId: ResourceIdString,
    voterMemberId: ResourceIdString,
    vote: zio.aws.managedblockchain.model.VoteValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.VoteOnProposalRequest = {
    import VoteOnProposalRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.VoteOnProposalRequest
      .builder()
      .networkId(ResourceIdString.unwrap(networkId): java.lang.String)
      .proposalId(ResourceIdString.unwrap(proposalId): java.lang.String)
      .voterMemberId(ResourceIdString.unwrap(voterMemberId): java.lang.String)
      .vote(vote.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchain.model.VoteOnProposalRequest.ReadOnly =
    zio.aws.managedblockchain.model.VoteOnProposalRequest.wrap(buildAwsValue())
}
object VoteOnProposalRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.VoteOnProposalRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.VoteOnProposalRequest =
      zio.aws.managedblockchain.model.VoteOnProposalRequest(
        networkId,
        proposalId,
        voterMemberId,
        vote
      )
    def networkId: ResourceIdString
    def proposalId: ResourceIdString
    def voterMemberId: ResourceIdString
    def vote: zio.aws.managedblockchain.model.VoteValue
    def getNetworkId: ZIO[Any, Nothing, ResourceIdString] =
      ZIO.succeed(networkId)
    def getProposalId: ZIO[Any, Nothing, ResourceIdString] =
      ZIO.succeed(proposalId)
    def getVoterMemberId: ZIO[Any, Nothing, ResourceIdString] =
      ZIO.succeed(voterMemberId)
    def getVote: ZIO[Any, Nothing, zio.aws.managedblockchain.model.VoteValue] =
      ZIO.succeed(vote)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.VoteOnProposalRequest
  ) extends zio.aws.managedblockchain.model.VoteOnProposalRequest.ReadOnly {
    override val networkId: ResourceIdString =
      zio.aws.managedblockchain.model.primitives
        .ResourceIdString(impl.networkId())
    override val proposalId: ResourceIdString =
      zio.aws.managedblockchain.model.primitives
        .ResourceIdString(impl.proposalId())
    override val voterMemberId: ResourceIdString =
      zio.aws.managedblockchain.model.primitives
        .ResourceIdString(impl.voterMemberId())
    override val vote: zio.aws.managedblockchain.model.VoteValue =
      zio.aws.managedblockchain.model.VoteValue.wrap(impl.vote())
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.VoteOnProposalRequest
  ): zio.aws.managedblockchain.model.VoteOnProposalRequest.ReadOnly =
    new Wrapper(impl)
}
