package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.{
  AvailabilityZoneString,
  InstanceTypeString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class NodeConfiguration(
    instanceType: InstanceTypeString,
    availabilityZone: Optional[AvailabilityZoneString] = Optional.Absent,
    logPublishingConfiguration: Optional[
      zio.aws.managedblockchain.model.NodeLogPublishingConfiguration
    ] = Optional.Absent,
    stateDB: Optional[zio.aws.managedblockchain.model.StateDBType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.NodeConfiguration = {
    import NodeConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.NodeConfiguration
      .builder()
      .instanceType(InstanceTypeString.unwrap(instanceType): java.lang.String)
      .optionallyWith(
        availabilityZone.map(value =>
          AvailabilityZoneString.unwrap(value): java.lang.String
        )
      )(_.availabilityZone)
      .optionallyWith(
        logPublishingConfiguration.map(value => value.buildAwsValue())
      )(_.logPublishingConfiguration)
      .optionallyWith(stateDB.map(value => value.unwrap))(_.stateDB)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.NodeConfiguration.ReadOnly =
    zio.aws.managedblockchain.model.NodeConfiguration.wrap(buildAwsValue())
}
object NodeConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.NodeConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.NodeConfiguration =
      zio.aws.managedblockchain.model.NodeConfiguration(
        instanceType,
        availabilityZone.map(value => value),
        logPublishingConfiguration.map(value => value.asEditable),
        stateDB.map(value => value)
      )
    def instanceType: InstanceTypeString
    def availabilityZone: Optional[AvailabilityZoneString]
    def logPublishingConfiguration: Optional[
      zio.aws.managedblockchain.model.NodeLogPublishingConfiguration.ReadOnly
    ]
    def stateDB: Optional[zio.aws.managedblockchain.model.StateDBType]
    def getInstanceType: ZIO[Any, Nothing, InstanceTypeString] =
      ZIO.succeed(instanceType)
    def getAvailabilityZone: ZIO[Any, AwsError, AvailabilityZoneString] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getLogPublishingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchain.model.NodeLogPublishingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "logPublishingConfiguration",
      logPublishingConfiguration
    )
    def getStateDB
        : ZIO[Any, AwsError, zio.aws.managedblockchain.model.StateDBType] =
      AwsError.unwrapOptionField("stateDB", stateDB)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.NodeConfiguration
  ) extends zio.aws.managedblockchain.model.NodeConfiguration.ReadOnly {
    override val instanceType: InstanceTypeString =
      zio.aws.managedblockchain.model.primitives
        .InstanceTypeString(impl.instanceType())
    override val availabilityZone: Optional[AvailabilityZoneString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZone())
        .map(value =>
          zio.aws.managedblockchain.model.primitives
            .AvailabilityZoneString(value)
        )
    override val logPublishingConfiguration: Optional[
      zio.aws.managedblockchain.model.NodeLogPublishingConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.logPublishingConfiguration())
      .map(value =>
        zio.aws.managedblockchain.model.NodeLogPublishingConfiguration
          .wrap(value)
      )
    override val stateDB
        : Optional[zio.aws.managedblockchain.model.StateDBType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateDB())
        .map(value => zio.aws.managedblockchain.model.StateDBType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.NodeConfiguration
  ): zio.aws.managedblockchain.model.NodeConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
