package zio.aws.managedblockchain.model
import scala.jdk.CollectionConverters.*
sealed trait AccessorStatus {
  def unwrap
      : software.amazon.awssdk.services.managedblockchain.model.AccessorStatus
}
object AccessorStatus {
  def wrap(
      value: software.amazon.awssdk.services.managedblockchain.model.AccessorStatus
  ): zio.aws.managedblockchain.model.AccessorStatus = value match {
    case software.amazon.awssdk.services.managedblockchain.model.AccessorStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.managedblockchain.model.AccessorStatus.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.managedblockchain.model.AccessorStatus.PENDING_DELETION =>
      val r = PENDING_DELETION
      r
    case software.amazon.awssdk.services.managedblockchain.model.AccessorStatus.DELETED =>
      val r = DELETED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.managedblockchain.model.AccessorStatus {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchain.model.AccessorStatus =
      software.amazon.awssdk.services.managedblockchain.model.AccessorStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object AVAILABLE extends zio.aws.managedblockchain.model.AccessorStatus {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchain.model.AccessorStatus =
      software.amazon.awssdk.services.managedblockchain.model.AccessorStatus.AVAILABLE
  }
  case object PENDING_DELETION
      extends zio.aws.managedblockchain.model.AccessorStatus {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchain.model.AccessorStatus =
      software.amazon.awssdk.services.managedblockchain.model.AccessorStatus.PENDING_DELETION
  }
  case object DELETED extends zio.aws.managedblockchain.model.AccessorStatus {
    override def unwrap
        : software.amazon.awssdk.services.managedblockchain.model.AccessorStatus =
      software.amazon.awssdk.services.managedblockchain.model.AccessorStatus.DELETED
  }
}
