package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.{
  TagValue,
  TagKey,
  ClientRequestTokenString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateAccessorRequest(
    clientRequestToken: ClientRequestTokenString,
    accessorType: zio.aws.managedblockchain.model.AccessorType,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.CreateAccessorRequest = {
    import CreateAccessorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.CreateAccessorRequest
      .builder()
      .clientRequestToken(
        ClientRequestTokenString.unwrap(clientRequestToken): java.lang.String
      )
      .accessorType(accessorType.unwrap)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchain.model.CreateAccessorRequest.ReadOnly =
    zio.aws.managedblockchain.model.CreateAccessorRequest.wrap(buildAwsValue())
}
object CreateAccessorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.CreateAccessorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.CreateAccessorRequest =
      zio.aws.managedblockchain.model.CreateAccessorRequest(
        clientRequestToken,
        accessorType,
        tags.map(value => value)
      )
    def clientRequestToken: ClientRequestTokenString
    def accessorType: zio.aws.managedblockchain.model.AccessorType
    def tags: Optional[Map[TagKey, TagValue]]
    def getClientRequestToken: ZIO[Any, Nothing, ClientRequestTokenString] =
      ZIO.succeed(clientRequestToken)
    def getAccessorType
        : ZIO[Any, Nothing, zio.aws.managedblockchain.model.AccessorType] =
      ZIO.succeed(accessorType)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.CreateAccessorRequest
  ) extends zio.aws.managedblockchain.model.CreateAccessorRequest.ReadOnly {
    override val clientRequestToken: ClientRequestTokenString =
      zio.aws.managedblockchain.model.primitives
        .ClientRequestTokenString(impl.clientRequestToken())
    override val accessorType: zio.aws.managedblockchain.model.AccessorType =
      zio.aws.managedblockchain.model.AccessorType.wrap(impl.accessorType())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.managedblockchain.model.primitives.TagKey(
              key
            ) -> zio.aws.managedblockchain.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.CreateAccessorRequest
  ): zio.aws.managedblockchain.model.CreateAccessorRequest.ReadOnly =
    new Wrapper(impl)
}
