package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.{
  AccessorBillingTokenString,
  ResourceIdString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateAccessorResponse(
    accessorId: Optional[ResourceIdString] = Optional.Absent,
    billingToken: Optional[AccessorBillingTokenString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.CreateAccessorResponse = {
    import CreateAccessorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.CreateAccessorResponse
      .builder()
      .optionallyWith(
        accessorId.map(value =>
          ResourceIdString.unwrap(value): java.lang.String
        )
      )(_.accessorId)
      .optionallyWith(
        billingToken.map(value =>
          AccessorBillingTokenString.unwrap(value): java.lang.String
        )
      )(_.billingToken)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchain.model.CreateAccessorResponse.ReadOnly =
    zio.aws.managedblockchain.model.CreateAccessorResponse.wrap(buildAwsValue())
}
object CreateAccessorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.CreateAccessorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.CreateAccessorResponse =
      zio.aws.managedblockchain.model.CreateAccessorResponse(
        accessorId.map(value => value),
        billingToken.map(value => value)
      )
    def accessorId: Optional[ResourceIdString]
    def billingToken: Optional[AccessorBillingTokenString]
    def getAccessorId: ZIO[Any, AwsError, ResourceIdString] =
      AwsError.unwrapOptionField("accessorId", accessorId)
    def getBillingToken: ZIO[Any, AwsError, AccessorBillingTokenString] =
      AwsError.unwrapOptionField("billingToken", billingToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.CreateAccessorResponse
  ) extends zio.aws.managedblockchain.model.CreateAccessorResponse.ReadOnly {
    override val accessorId: Optional[ResourceIdString] = zio.aws.core.internal
      .optionalFromNullable(impl.accessorId())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.ResourceIdString(value)
      )
    override val billingToken: Optional[AccessorBillingTokenString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.billingToken())
        .map(value =>
          zio.aws.managedblockchain.model.primitives
            .AccessorBillingTokenString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.CreateAccessorResponse
  ): zio.aws.managedblockchain.model.CreateAccessorResponse.ReadOnly =
    new Wrapper(impl)
}
