package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.PrincipalString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class InviteAction(principal: PrincipalString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.InviteAction = {
    import InviteAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.InviteAction
      .builder()
      .principal(PrincipalString.unwrap(principal): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.InviteAction.ReadOnly =
    zio.aws.managedblockchain.model.InviteAction.wrap(buildAwsValue())
}
object InviteAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.InviteAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.InviteAction =
      zio.aws.managedblockchain.model.InviteAction(principal)
    def principal: PrincipalString
    def getPrincipal: ZIO[Any, Nothing, PrincipalString] =
      ZIO.succeed(principal)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.InviteAction
  ) extends zio.aws.managedblockchain.model.InviteAction.ReadOnly {
    override val principal: PrincipalString =
      zio.aws.managedblockchain.model.primitives
        .PrincipalString(impl.principal())
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.InviteAction
  ): zio.aws.managedblockchain.model.InviteAction.ReadOnly = new Wrapper(impl)
}
