package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.ResourceIdString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateMemberRequest(
    networkId: ResourceIdString,
    memberId: ResourceIdString,
    logPublishingConfiguration: Optional[
      zio.aws.managedblockchain.model.MemberLogPublishingConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.UpdateMemberRequest = {
    import UpdateMemberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.UpdateMemberRequest
      .builder()
      .networkId(ResourceIdString.unwrap(networkId): java.lang.String)
      .memberId(ResourceIdString.unwrap(memberId): java.lang.String)
      .optionallyWith(
        logPublishingConfiguration.map(value => value.buildAwsValue())
      )(_.logPublishingConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.UpdateMemberRequest.ReadOnly =
    zio.aws.managedblockchain.model.UpdateMemberRequest.wrap(buildAwsValue())
}
object UpdateMemberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.UpdateMemberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.UpdateMemberRequest =
      zio.aws.managedblockchain.model.UpdateMemberRequest(
        networkId,
        memberId,
        logPublishingConfiguration.map(value => value.asEditable)
      )
    def networkId: ResourceIdString
    def memberId: ResourceIdString
    def logPublishingConfiguration: Optional[
      zio.aws.managedblockchain.model.MemberLogPublishingConfiguration.ReadOnly
    ]
    def getNetworkId: ZIO[Any, Nothing, ResourceIdString] =
      ZIO.succeed(networkId)
    def getMemberId: ZIO[Any, Nothing, ResourceIdString] = ZIO.succeed(memberId)
    def getLogPublishingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchain.model.MemberLogPublishingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "logPublishingConfiguration",
      logPublishingConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.UpdateMemberRequest
  ) extends zio.aws.managedblockchain.model.UpdateMemberRequest.ReadOnly {
    override val networkId: ResourceIdString =
      zio.aws.managedblockchain.model.primitives
        .ResourceIdString(impl.networkId())
    override val memberId: ResourceIdString =
      zio.aws.managedblockchain.model.primitives
        .ResourceIdString(impl.memberId())
    override val logPublishingConfiguration: Optional[
      zio.aws.managedblockchain.model.MemberLogPublishingConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.logPublishingConfiguration())
      .map(value =>
        zio.aws.managedblockchain.model.MemberLogPublishingConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.UpdateMemberRequest
  ): zio.aws.managedblockchain.model.UpdateMemberRequest.ReadOnly = new Wrapper(
    impl
  )
}
