package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.{
  ResourceIdString,
  NetworkMemberNameString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class VoteSummary(
    vote: Optional[zio.aws.managedblockchain.model.VoteValue] = Optional.Absent,
    memberName: Optional[NetworkMemberNameString] = Optional.Absent,
    memberId: Optional[ResourceIdString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.VoteSummary = {
    import VoteSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.VoteSummary
      .builder()
      .optionallyWith(vote.map(value => value.unwrap))(_.vote)
      .optionallyWith(
        memberName.map(value =>
          NetworkMemberNameString.unwrap(value): java.lang.String
        )
      )(_.memberName)
      .optionallyWith(
        memberId.map(value => ResourceIdString.unwrap(value): java.lang.String)
      )(_.memberId)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.VoteSummary.ReadOnly =
    zio.aws.managedblockchain.model.VoteSummary.wrap(buildAwsValue())
}
object VoteSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.VoteSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.VoteSummary =
      zio.aws.managedblockchain.model.VoteSummary(
        vote.map(value => value),
        memberName.map(value => value),
        memberId.map(value => value)
      )
    def vote: Optional[zio.aws.managedblockchain.model.VoteValue]
    def memberName: Optional[NetworkMemberNameString]
    def memberId: Optional[ResourceIdString]
    def getVote: ZIO[Any, AwsError, zio.aws.managedblockchain.model.VoteValue] =
      AwsError.unwrapOptionField("vote", vote)
    def getMemberName: ZIO[Any, AwsError, NetworkMemberNameString] =
      AwsError.unwrapOptionField("memberName", memberName)
    def getMemberId: ZIO[Any, AwsError, ResourceIdString] =
      AwsError.unwrapOptionField("memberId", memberId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.VoteSummary
  ) extends zio.aws.managedblockchain.model.VoteSummary.ReadOnly {
    override val vote: Optional[zio.aws.managedblockchain.model.VoteValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vote())
        .map(value => zio.aws.managedblockchain.model.VoteValue.wrap(value))
    override val memberName: Optional[NetworkMemberNameString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.memberName())
        .map(value =>
          zio.aws.managedblockchain.model.primitives
            .NetworkMemberNameString(value)
        )
    override val memberId: Optional[ResourceIdString] = zio.aws.core.internal
      .optionalFromNullable(impl.memberId())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.ResourceIdString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.VoteSummary
  ): zio.aws.managedblockchain.model.VoteSummary.ReadOnly = new Wrapper(impl)
}
