package zio.aws.managedblockchain.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MemberFrameworkConfiguration(
    fabric: Optional[
      zio.aws.managedblockchain.model.MemberFabricConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.MemberFrameworkConfiguration = {
    import MemberFrameworkConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.MemberFrameworkConfiguration
      .builder()
      .optionallyWith(fabric.map(value => value.buildAwsValue()))(_.fabric)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchain.model.MemberFrameworkConfiguration.ReadOnly =
    zio.aws.managedblockchain.model.MemberFrameworkConfiguration
      .wrap(buildAwsValue())
}
object MemberFrameworkConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.MemberFrameworkConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.managedblockchain.model.MemberFrameworkConfiguration =
      zio.aws.managedblockchain.model
        .MemberFrameworkConfiguration(fabric.map(value => value.asEditable))
    def fabric: Optional[
      zio.aws.managedblockchain.model.MemberFabricConfiguration.ReadOnly
    ]
    def getFabric: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchain.model.MemberFabricConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("fabric", fabric)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.MemberFrameworkConfiguration
  ) extends zio.aws.managedblockchain.model.MemberFrameworkConfiguration.ReadOnly {
    override val fabric: Optional[
      zio.aws.managedblockchain.model.MemberFabricConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.fabric())
      .map(value =>
        zio.aws.managedblockchain.model.MemberFabricConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.MemberFrameworkConfiguration
  ): zio.aws.managedblockchain.model.MemberFrameworkConfiguration.ReadOnly =
    new Wrapper(impl)
}
