package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListProposalVotesResponse(
    proposalVotes: Optional[
      Iterable[zio.aws.managedblockchain.model.VoteSummary]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.ListProposalVotesResponse = {
    import ListProposalVotesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.ListProposalVotesResponse
      .builder()
      .optionallyWith(
        proposalVotes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.proposalVotes)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchain.model.ListProposalVotesResponse.ReadOnly =
    zio.aws.managedblockchain.model.ListProposalVotesResponse
      .wrap(buildAwsValue())
}
object ListProposalVotesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.ListProposalVotesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.ListProposalVotesResponse =
      zio.aws.managedblockchain.model.ListProposalVotesResponse(
        proposalVotes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def proposalVotes
        : Optional[List[zio.aws.managedblockchain.model.VoteSummary.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getProposalVotes: ZIO[Any, AwsError, List[
      zio.aws.managedblockchain.model.VoteSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("proposalVotes", proposalVotes)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.ListProposalVotesResponse
  ) extends zio.aws.managedblockchain.model.ListProposalVotesResponse.ReadOnly {
    override val proposalVotes
        : Optional[List[zio.aws.managedblockchain.model.VoteSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.proposalVotes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.managedblockchain.model.VoteSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.ListProposalVotesResponse
  ): zio.aws.managedblockchain.model.ListProposalVotesResponse.ReadOnly =
    new Wrapper(impl)
}
