package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.ResourceIdString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetNetworkRequest(networkId: ResourceIdString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.GetNetworkRequest = {
    import GetNetworkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.GetNetworkRequest
      .builder()
      .networkId(ResourceIdString.unwrap(networkId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.GetNetworkRequest.ReadOnly =
    zio.aws.managedblockchain.model.GetNetworkRequest.wrap(buildAwsValue())
}
object GetNetworkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.GetNetworkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.GetNetworkRequest =
      zio.aws.managedblockchain.model.GetNetworkRequest(networkId)
    def networkId: ResourceIdString
    def getNetworkId: ZIO[Any, Nothing, ResourceIdString] =
      ZIO.succeed(networkId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.GetNetworkRequest
  ) extends zio.aws.managedblockchain.model.GetNetworkRequest.ReadOnly {
    override val networkId: ResourceIdString =
      zio.aws.managedblockchain.model.primitives
        .ResourceIdString(impl.networkId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.GetNetworkRequest
  ): zio.aws.managedblockchain.model.GetNetworkRequest.ReadOnly = new Wrapper(
    impl
  )
}
