package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.{
  ClientRequestTokenString,
  TagValue,
  ResourceIdString,
  DescriptionString,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateProposalRequest(
    clientRequestToken: ClientRequestTokenString,
    networkId: ResourceIdString,
    memberId: ResourceIdString,
    actions: zio.aws.managedblockchain.model.ProposalActions,
    description: Optional[DescriptionString] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.CreateProposalRequest = {
    import CreateProposalRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.CreateProposalRequest
      .builder()
      .clientRequestToken(
        ClientRequestTokenString.unwrap(clientRequestToken): java.lang.String
      )
      .networkId(ResourceIdString.unwrap(networkId): java.lang.String)
      .memberId(ResourceIdString.unwrap(memberId): java.lang.String)
      .actions(actions.buildAwsValue())
      .optionallyWith(
        description.map(value =>
          DescriptionString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchain.model.CreateProposalRequest.ReadOnly =
    zio.aws.managedblockchain.model.CreateProposalRequest.wrap(buildAwsValue())
}
object CreateProposalRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.CreateProposalRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.CreateProposalRequest =
      zio.aws.managedblockchain.model.CreateProposalRequest(
        clientRequestToken,
        networkId,
        memberId,
        actions.asEditable,
        description.map(value => value),
        tags.map(value => value)
      )
    def clientRequestToken: ClientRequestTokenString
    def networkId: ResourceIdString
    def memberId: ResourceIdString
    def actions: zio.aws.managedblockchain.model.ProposalActions.ReadOnly
    def description: Optional[DescriptionString]
    def tags: Optional[Map[TagKey, TagValue]]
    def getClientRequestToken: ZIO[Any, Nothing, ClientRequestTokenString] =
      ZIO.succeed(clientRequestToken)
    def getNetworkId: ZIO[Any, Nothing, ResourceIdString] =
      ZIO.succeed(networkId)
    def getMemberId: ZIO[Any, Nothing, ResourceIdString] = ZIO.succeed(memberId)
    def getActions: ZIO[
      Any,
      Nothing,
      zio.aws.managedblockchain.model.ProposalActions.ReadOnly
    ] = ZIO.succeed(actions)
    def getDescription: ZIO[Any, AwsError, DescriptionString] =
      AwsError.unwrapOptionField("description", description)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.CreateProposalRequest
  ) extends zio.aws.managedblockchain.model.CreateProposalRequest.ReadOnly {
    override val clientRequestToken: ClientRequestTokenString =
      zio.aws.managedblockchain.model.primitives
        .ClientRequestTokenString(impl.clientRequestToken())
    override val networkId: ResourceIdString =
      zio.aws.managedblockchain.model.primitives
        .ResourceIdString(impl.networkId())
    override val memberId: ResourceIdString =
      zio.aws.managedblockchain.model.primitives
        .ResourceIdString(impl.memberId())
    override val actions
        : zio.aws.managedblockchain.model.ProposalActions.ReadOnly =
      zio.aws.managedblockchain.model.ProposalActions.wrap(impl.actions())
    override val description: Optional[DescriptionString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.managedblockchain.model.primitives.DescriptionString(value)
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.managedblockchain.model.primitives.TagKey(
              key
            ) -> zio.aws.managedblockchain.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.CreateProposalRequest
  ): zio.aws.managedblockchain.model.CreateProposalRequest.ReadOnly =
    new Wrapper(impl)
}
