package zio.aws.managedblockchain.model
import zio.aws.managedblockchain.model.primitives.ArnString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(resourceArn: ArnString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(ArnString.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchain.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.managedblockchain.model.ListTagsForResourceRequest
      .wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.ListTagsForResourceRequest =
      zio.aws.managedblockchain.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: ArnString
    def getResourceArn: ZIO[Any, Nothing, ArnString] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.ListTagsForResourceRequest
  ) extends zio.aws.managedblockchain.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: ArnString =
      zio.aws.managedblockchain.model.primitives.ArnString(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.ListTagsForResourceRequest
  ): zio.aws.managedblockchain.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
