package zio.aws.managedblockchain.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.managedblockchain.model.primitives.{
  PaginationToken,
  MemberListMaxResults,
  IsOwned,
  ResourceIdString
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListMembersRequest(
    networkId: ResourceIdString,
    name: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.managedblockchain.model.MemberStatus] =
      Optional.Absent,
    isOwned: Optional[IsOwned] = Optional.Absent,
    maxResults: Optional[MemberListMaxResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.ListMembersRequest = {
    import ListMembersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.ListMembersRequest
      .builder()
      .networkId(ResourceIdString.unwrap(networkId): java.lang.String)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        isOwned.map(value => IsOwned.unwrap(value): java.lang.Boolean)
      )(_.isOwned)
      .optionallyWith(
        maxResults.map(value => MemberListMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.managedblockchain.model.ListMembersRequest.ReadOnly =
    zio.aws.managedblockchain.model.ListMembersRequest.wrap(buildAwsValue())
}
object ListMembersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.ListMembersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.ListMembersRequest =
      zio.aws.managedblockchain.model.ListMembersRequest(
        networkId,
        name.map(value => value),
        status.map(value => value),
        isOwned.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def networkId: ResourceIdString
    def name: Optional[String]
    def status: Optional[zio.aws.managedblockchain.model.MemberStatus]
    def isOwned: Optional[IsOwned]
    def maxResults: Optional[MemberListMaxResults]
    def nextToken: Optional[PaginationToken]
    def getNetworkId: ZIO[Any, Nothing, ResourceIdString] =
      ZIO.succeed(networkId)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.managedblockchain.model.MemberStatus] =
      AwsError.unwrapOptionField("status", status)
    def getIsOwned: ZIO[Any, AwsError, IsOwned] =
      AwsError.unwrapOptionField("isOwned", isOwned)
    def getMaxResults: ZIO[Any, AwsError, MemberListMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.ListMembersRequest
  ) extends zio.aws.managedblockchain.model.ListMembersRequest.ReadOnly {
    override val networkId: ResourceIdString =
      zio.aws.managedblockchain.model.primitives
        .ResourceIdString(impl.networkId())
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val status
        : Optional[zio.aws.managedblockchain.model.MemberStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.managedblockchain.model.MemberStatus.wrap(value))
    override val isOwned: Optional[IsOwned] = zio.aws.core.internal
      .optionalFromNullable(impl.isOwned())
      .map(value => zio.aws.managedblockchain.model.primitives.IsOwned(value))
    override val maxResults: Optional[MemberListMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.managedblockchain.model.primitives.MemberListMaxResults(value)
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.managedblockchain.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.ListMembersRequest
  ): zio.aws.managedblockchain.model.ListMembersRequest.ReadOnly = new Wrapper(
    impl
  )
}
