package zio.aws.managedblockchain.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MemberFrameworkAttributes(
    fabric: Optional[zio.aws.managedblockchain.model.MemberFabricAttributes] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.managedblockchain.model.MemberFrameworkAttributes = {
    import MemberFrameworkAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.managedblockchain.model.MemberFrameworkAttributes
      .builder()
      .optionallyWith(fabric.map(value => value.buildAwsValue()))(_.fabric)
      .build()
  }
  def asReadOnly
      : zio.aws.managedblockchain.model.MemberFrameworkAttributes.ReadOnly =
    zio.aws.managedblockchain.model.MemberFrameworkAttributes
      .wrap(buildAwsValue())
}
object MemberFrameworkAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.managedblockchain.model.MemberFrameworkAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.managedblockchain.model.MemberFrameworkAttributes =
      zio.aws.managedblockchain.model
        .MemberFrameworkAttributes(fabric.map(value => value.asEditable))
    def fabric: Optional[
      zio.aws.managedblockchain.model.MemberFabricAttributes.ReadOnly
    ]
    def getFabric: ZIO[
      Any,
      AwsError,
      zio.aws.managedblockchain.model.MemberFabricAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("fabric", fabric)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.managedblockchain.model.MemberFrameworkAttributes
  ) extends zio.aws.managedblockchain.model.MemberFrameworkAttributes.ReadOnly {
    override val fabric: Optional[
      zio.aws.managedblockchain.model.MemberFabricAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.fabric())
      .map(value =>
        zio.aws.managedblockchain.model.MemberFabricAttributes.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.managedblockchain.model.MemberFrameworkAttributes
  ): zio.aws.managedblockchain.model.MemberFrameworkAttributes.ReadOnly =
    new Wrapper(impl)
}
